float CauSpriteSize;
float CauSpriteIntens;

struct VS_OUT
{
	float4 hPosition	: POSITION;
	float4 texCoord		: TEXCOORD0;
	float4 color		: COLOR0;
	float2 r			: TEXCOORD1;
	float2 center		: TEXCOORD2;
	float4 position		: TEXCOORD3;
	float pSize			: PSIZE;
	float dist			: TEXCOORD4;
};

VS_OUT CauVS(float4 position : POSITION,	
		float4 texCoord : TEXCOORD0,
		float4 color 	: COLOR0,
		uniform float4x4 worldView,
		uniform float4x4 Proj,
		uniform float4x4 worldViewProj,
		uniform float resolution,
		uniform sampler2D PhotonHitMap : register(s0))
{
  VS_OUT OUT;
     
   float radius = CauSpriteSize;
   OUT.pSize = radius;
   float4 cPosition;  

  float4 pos = tex2Dlod(PhotonHitMap, float4(position.x, 1.0 - position.y,0,0)).rgba;
//	float4 pos = float4(0,0,-0.5,1);
   if(pos.a == 0)//no photon hit
   {
		OUT.center = 1000.0f;
		OUT.position = OUT.hPosition = 1000.0f; //transform out of view
   }
   else
   {
   		float4 wPosition = float4(normalize(pos.xyz),1); 
    
		cPosition = mul(worldView, wPosition);
		OUT.center = cPosition.xy;
		OUT.position = cPosition;	
		OUT.hPosition = mul(Proj, cPosition);		
	 }	
  
   OUT.r.x = radius;
   OUT.r.y = radius;
   OUT.texCoord = texCoord;
   OUT.color = 1; 
   OUT.color = float4(pos);
   OUT.dist = length(pos.xyz);
   
   return OUT;
}


float4 CauPS(VS_OUT IN,
		uniform float3 color,
		uniform sampler2D intensityTex : register(s1)
		 ):COLOR
{

 // float2 texcoord = (IN.center - IN.position.xy) / IN.r.x;
 // texcoord = (texcoord + 1.0) * 0.5;
  IN.color.rgb = color;
  float intens = tex2D(intensityTex, IN.texCoord).r;
  IN.color.a = intens * CauSpriteIntens;
  return IN.color;  
}


