
float farplane = 1000.0; //far plane
float nearplane = 0.1; //far plane
float width = 800;
float height = 600;

struct SBB_VS_OUT
{
	float4 hPosition	: POSITION;
	float4 texCoord		: TEXCOORD0;
	float3 P		: TEXCOORD1;
	float3 Q		: TEXCOORD2;
	float r			: TEXCOORD3;
	float2 screenCoord	: TEXCOORD4;	
	float4 color		: COLOR0;
};

SBB_VS_OUT FireVS (float4 position : POSITION,	
		float4 texCoord : TEXCOORD0,
		float4 color 	: COLOR,
		uniform float4x4 worldView,
		uniform float4x4 Proj,
		uniform float4x4 worldViewProj)
{
	SBB_VS_OUT OUT;
  
	float2 offset = texCoord.zw;
	float4 cPosition;   
	float4 wPosition = position;    
	cPosition = mul(worldView, wPosition);	
	OUT.P = cPosition.xyz;
	OUT.P.z = - 1 * OUT.P.z;
	cPosition.xy += offset;				
	OUT.Q = cPosition.xyz;	
	OUT.Q.z = OUT.P.z;
	OUT.r = abs(texCoord.z);		

   /*texCoord.y = 1.0 - texCoord.y;
   float2 offset = texCoord.xy * 2.0 - 1.0;
   float4 cPosition = mul(worldView, position);
   OUT.P = cPosition.xyz;
   OUT.P.z = - 1 * OUT.P.z; // - texCoord.w;
   cPosition.xy += offset * texCoord.w;
   OUT.Q = cPosition.xyz;
   OUT.Q.z = OUT.P.z;
   OUT.r = texCoord.w;*/
  
   OUT.hPosition = mul( Proj, cPosition );
   OUT.screenCoord =  (OUT.hPosition.xy / OUT.hPosition.w + 1.0) / 2.0;
   OUT.screenCoord.y = 1.0 - OUT.screenCoord.y;
   OUT.screenCoord += float2(0.5/width, 0.5/height);   
   
   OUT.texCoord = texCoord;
   OUT.color = color;


  return OUT;
} 


void FirePS(SBB_VS_OUT IN ,
	//	in screenCoord : VPOS,
		uniform sampler2D colorTexture : register(s0),
		uniform sampler2D DepthMap : register(s1)
		,uniform sampler2D PlanckMap : register(s2),
		uniform sampler2D gradTex : register(s3),
		uniform sampler2D heatTex : register(s4),
		out float4 Color : COLOR0,
		out float4 Heat: COLOR1)
{
	Color = IN.color;
	float alpha = 0;
	
	
	float d = length( IN.Q - IN.P );
	float Zs;
	
	if( d < IN.r )
	{	 
		float w = sqrt( IN.r * IN.r - d * d );
		alpha = w / IN.r;
		//alpha *= pow( (IN.r-d) / IN.r , 2);
	
		float F = IN.Q.z - w;
		float B = IN.Q.z + w;	 

		Zs = tex2D( DepthMap, IN.screenCoord ).r;
		if(Zs == 0) Zs = farplane;
		float ds = min( Zs, B ) - max( nearplane, F );	 
		
		alpha *=  ds / w * 0.5;	
	}
	
	alpha = saturate(alpha);
	Color.a = alpha * tex2D( colorTexture, IN.texCoord.xy).r ;
	Color.a *= IN.color.a;
	Color.rgb = tex2D( PlanckMap, Color.aa).rgb;
	float grad = tex2D(gradTex, IN.texCoord.xy).r;
	Color.a *= grad;

	Heat = float4(0,0,0,0.5);	
	Heat.rg = (tex2D(heatTex, IN.texCoord.xy).rg * 2.0 - 1.0) * grad * alpha * IN.color.a;
	
}

struct VS_OUT
{
	float4 hPosition	: POSITION;
	float2 texCoord		: TEXCOORD0;	
};


float4 FireHeatCompositorPS(VS_OUT IN,
		uniform float width,
		uniform float height,
		uniform sampler2D Scene: register(s0)
		,uniform sampler2D FireColor: register(s1)
		,uniform sampler2D FireHeatNoise: register(s2)
		 ):COLOR
{	
	float maxOffset = 0.035;
	float4 Color = 1;

	float2 offset = tex2D(FireHeatNoise,IN.texCoord ).rg;
		
	offset *= maxOffset;
	float2 newTex = IN.texCoord + offset;
	float4 SceneSample = tex2D(Scene, newTex );
	float4 FireSample  = tex2D(FireColor, newTex );
	
	Color = SceneSample + FireSample;// + float4(offset,1,1);	
	
	return Color;
}

