float4x4 world_IT;
int REDUCED_CUBEMAP_SIZE = 8;


float4 readCubeMap(samplerCUBE cm, float3 coord)		
{
	float4 color = texCUBE( cm, float3(coord.xy, - coord.z) );
	return color;
}

float readDistanceCubeMap(samplerCUBE dcm, float3 coord)		
{
	float dist = texCUBE(dcm, float3(coord.xy, - coord.z)).r;
	if(dist == 0) dist = 4000; ///sky
	return dist;
}

// This function is called several times.
float3 Hit( float3 x, float3 R, samplerCUBE mp )
{
	float rl = readDistanceCubeMap( mp, R);				// |r|
	
	float ppp = length( x ) /  readDistanceCubeMap( mp, x);			// |p|/|p|
	float dun = 0, pun = ppp, dov = 0, pov = 0;
	float dl = rl * ( 1 - ppp );							// eq. 2
	float3 l = x + R * dl;									// ray equation

	// iteration
	for( int i = 0; i < 2; i++ )	// 2 !!!!!!!!!!!!!!!!!!!!!!!
	{
		float llp = length( l ) / readDistanceCubeMap( mp, l);		// |l|/|l|
		if ( llp < 0.999f )									// undershooting
		{
			dun = dl; pun = llp;							// last undershooting
			dl += ( dov == 0 ) ? rl * ( 1 - llp ) :			// eq. 2
				( dl - dov ) * ( 1 - llp ) / ( llp - pov );	// eq. 3
		} else if ( llp > 1.001f )							// overshooting
		{
			dov = dl; pov = llp;							// last overshooting
			dl += ( dl -dun ) * ( 1 - llp ) / ( llp - pun );// eq. 3
		}
		l = x + R * dl;										// ray equation
	}
	return l;												// computed hit point
}

float4 GetContibution(float3 L, float3 pos, float3 N, float3 V, samplerCUBE SmallEnvMapSampler, samplerCUBE DistanceEnvMapSampler)	// Phong-Blinn
// L: a hossza lnyeges (az egysgkocka falig r)
{
    REDUCED_CUBEMAP_SIZE = 4;
    float mindist = 1.0;
    
	float kd = 0.3;	// 0.3
	float ks = 0;	// 0.5
	float shininess = 10;
	
	float l = length(L);
	L = normalize(L);

	//dw
	float dw = 4 / (REDUCED_CUBEMAP_SIZE*REDUCED_CUBEMAP_SIZE*l*l*l + 4/3.1416f);
	//Lin
	float4 Lin = readCubeMap(SmallEnvMapSampler, L);
	//r
	float doy = readDistanceCubeMap(DistanceEnvMapSampler, L);
	float dxy = length(L * doy - pos);
	
	dxy = max(mindist, dxy);
		

	//dws
	float dws = (doy*doy * dw) / (dxy*dxy*(1 - dw/3.1416f) + doy*doy*dw/3.1416f);	// localization:
	//float dws = dw;
	
	//L = L * doy - pos;	// L: x->y, az objektumtl induljon, ne a kzppontbl
	L = normalize(L);
	float3 H = normalize(L + V);	// felezvektor

	float a = kd * max(dot(N,L),0) + 
			  ks * pow(max(dot(N,H),0), shininess); // diffuse + specular

	// 1.: eddigi
	//return Lin * a * dws;
	
	float ctheta_in = dot(N,L);
	float ctheta_out = dot(N,V);	
	
	return Lin * a * dws;		
}

void DiffuseVS(float4 position : POSITION,
		float3 normal   : NORMAL,
		half3 tangent   : TEXCOORD1, 
		float2 texCoord : TEXCOORD0,
		out float2 otexCoord : TEXCOORD0,
		out float3 wPos	: TEXCOORD1,				
		out float3 mNormal  : TEXCOORD2,
		out half3 Tangent   : TEXCOORD3,	 
		out half3 Binormal  : TEXCOORD4,	 
		out float4 hPos : POSITION,		
		uniform float4x4 worldViewProj,
		uniform float4x4 world)
{
 
  hPos = mul(worldViewProj, position);
  wPos = mul(world, position).xyz;  
  //mNormal = mul(normal, world_IT);
  mNormal = normal;
  otexCoord = texCoord;
  Tangent = tangent;  
  Binormal = cross(tangent, normal); 
}

float4 DiffusePS( float2 Tex : TEXCOORD0,
           float3 pos : TEXCOORD1,
           float3 N : TEXCOORD2,
           half3 Tangent   : TEXCOORD3,	 
		   half3 Binormal  : TEXCOORD4,
           uniform float3 cameraPos,
           uniform float3 lastCenter,
           uniform half3 lightPosition,				
           uniform samplerCUBE SmallEnvMapSampler : register(s0),
           uniform samplerCUBE DistanceEnvMapSampler : register(s1),
		   uniform sampler2D ColorTexture : register(s2),
		   uniform sampler2D NormalMap : register(s3)				
            ) : COLOR0
{
    REDUCED_CUBEMAP_SIZE = 4;
	
    //V = /*-*/normalize( V );
    float3 V = normalize(pos - cameraPos);	// 
    
    float3x3 ModelToTangent = float3x3(Tangent, Binormal, N); 
	half3 tNormal = tex2D(NormalMap, Tex).rgb;     	
      
    N =mul(tNormal, ModelToTangent );
    N = mul( N, world_IT );
    N = normalize(N);
    
    float3 R = reflect(V, N);
    pos -= lastCenter;	
        
    float4 intens = 0;
    
	
	for (int x = 0; x < REDUCED_CUBEMAP_SIZE; x++)			// az envmap minden texelre
	 for (int y = 0; y < REDUCED_CUBEMAP_SIZE; y++)
	 {
		// intenzits kiolvassa az adott texelbl 
		
		float2 p, tpos; 
	    tpos.x = x/(float)REDUCED_CUBEMAP_SIZE;	// 0..1
	    tpos.y = y/(float)REDUCED_CUBEMAP_SIZE;	// 0..1
	    tpos.xy += float2(0.5/REDUCED_CUBEMAP_SIZE, 0.5/REDUCED_CUBEMAP_SIZE);	// az adott texel kzppont uv koordinti
	    
	    p.x = tpos.x; 
	    p.y = 1-tpos.y;
	    p.xy = 2*p.xy - 1;	// -1..1	// az adott texel kzppont pozcija
	    
	    float3 L;
	    
		L = float3(p.x, p.y, 1);
		intens += GetContibution( L, pos, N, V, SmallEnvMapSampler, DistanceEnvMapSampler);
		
		L = float3(p.x, p.y, -1);
		intens += GetContibution( L, pos, N, V, SmallEnvMapSampler, DistanceEnvMapSampler);
		
		L = float3(p.x, 1, p.y);
		intens += GetContibution( L, pos, N, V, SmallEnvMapSampler, DistanceEnvMapSampler);
		
		L = float3(p.x, -1, p.y);
		intens += GetContibution( L, pos, N, V, SmallEnvMapSampler, DistanceEnvMapSampler);
		
		L = float3(1, p.x, p.y);
		intens += GetContibution( L, pos, N, V, SmallEnvMapSampler, DistanceEnvMapSampler);
		
		L = float3(-1, p.x, p.y);
		intens += GetContibution( L, pos, N, V, SmallEnvMapSampler, DistanceEnvMapSampler);
	}
	
	half3 light = lightPosition;
	half3 L = normalize(light);
	half3 H = normalize(L + V);
	half4 lighting = lit(dot(N, L),dot(N, H), 20);

	float4 retColor = intens;
	float4 texColor = tex2D(ColorTexture, Tex);
	retColor = intens * texColor * 1.5
			  + lighting.y * texColor * 0.15 
			  + lighting.z * 0.15			
			 ;
	return retColor;
}