float3 F0;

float4 readCubeMap(samplerCUBE cm, float3 coord)		
{
	float4 color = texCUBE( cm, float3(coord.xy, - coord.z) );
	return color;
}

float readDistanceCubeMap(samplerCUBE dcm, float3 coord)		
{
	float dist = texCUBE(dcm, float3(coord.xy, - coord.z)).r;
	if(dist == 0) dist = 1000000; ///sky
	return dist;
}


float3 Hit( float3 x, float3 R, samplerCUBE mp )
{
	float rl = readDistanceCubeMap( mp, R);				// |r|
	
	float ppp = length( x ) /  readDistanceCubeMap( mp, x);			// |p|/|p|
	float dun = 0, pun = ppp, dov = 0, pov = 0;
	float dl = rl * ( 1 - ppp );							// eq. 2
	float3 l = x + R * dl;									// ray equation

	// iteration
	for( int i = 0; i < 2; i++ )	// 2 !!!!!!!!!!!!!!!!!!!!!!!
	{
		float llp = length( l ) / readDistanceCubeMap( mp, l);		// |l|/|l|
		if ( llp < 0.999f )									// undershooting
		{
			dun = dl; pun = llp;							// last undershooting
			dl += ( dov == 0 ) ? rl * ( 1 - llp ) :			// eq. 2
				( dl - dov ) * ( 1 - llp ) / ( llp - pov );	// eq. 3
		} else if ( llp > 1.001f )							// overshooting
		{
			dov = dl; pov = llp;							// last overshooting
			dl += ( dl -dun ) * ( 1 - llp ) / ( llp - pun );// eq. 3
		}
		l = x + R * dl;										// ray equation
	}
	return l;												// computed hit point
}

void LocalizedVS(float4 position : POSITION,
		out float3 wPos	: TEXCOORD1,				
		float2 texCoord : TEXCOORD0,
		out float2 otexCoord : TEXCOORD0,
		float3 normal   : NORMAL,
		out float3 mNormal  : TEXCOORD2,
		out float4 hPos : POSITION,		
		uniform float4x4 worldViewProj,
		uniform float4x4 world,
		uniform float4x4 worldIT)
{
 
  hPos = mul(worldViewProj, position);
  wPos = mul(world, position).xyz;  
  mNormal = mul(normal, worldIT);
  //mNormal *=-1;
 //mNormal = normal;  
  otexCoord = texCoord;
}


void LocalizedMetalPS(  float2 texCoord : TEXCOORD0, 
		float3 wPos	: TEXCOORD1,	
		float3 mNormal  : TEXCOORD2,
		uniform float3 cameraPos,
		uniform samplerCUBE CubeMap : register(s0),
		uniform samplerCUBE DistanceMap : register(s1),
		uniform float3 lastCenter,
		uniform float3 lightPosition,
		uniform float reflectivity,
		uniform float3 phongColor,				
		out float4 Color :COLOR0)
{	
	Color = float4(1,1,1,1);

	//metallic reflection	
	mNormal = normalize(mNormal);
	
	float3 newTexCoord;	
	float3 mPos = wPos - lastCenter;
	float3 V = normalize(wPos - cameraPos);
	float3 R = normalize(reflect( V, mNormal));
		
	newTexCoord = R;	
	
	newTexCoord = Hit(mPos, R, DistanceMap);
	Color = readCubeMap(CubeMap, newTexCoord );	
	
	//Color =  0.000000001 *Color +  float4(mNormal, 1);
	
	float ctheta_in = dot(mNormal,R);
	float ctheta_out = dot(mNormal,-V);

	float3 F = 0;
	
	if ( ctheta_in > 0 && ctheta_out > 0 )
	{
		float3 H1 = normalize(R - V);	// felezvektor
		float cbeta  = dot(H1,R);		
		F = F0 + (1-F0)*pow(1-cbeta,5);
	}		
	
	Color = Color * float4(F,1);
	
	
//phong
	
	half3 light = lightPosition; //(lightPosition -wPos) ;// / 200.0;
	V = -V;
	half3 L = normalize(light);
	half3 H = normalize(L+V);
	half4 lighting = lit(dot(mNormal, L),dot(mNormal, H), 200);
	
//addition
	Color = Color * reflectivity + (1 - reflectivity) * (
										(lighting.x * float4(phongColor * 0.2,1) + 
										 lighting.y * float4(phongColor,1) + 
										 lighting.z * float4(4,4,4,4) )) ;
}

void MirrorPS(  float2 texCoord : TEXCOORD0, 
		float3 wPos	: TEXCOORD1,	
		float3 mNormal  : TEXCOORD2,
		uniform float3 cameraPos,
		uniform samplerCUBE CubeMap : register(s0),
		uniform samplerCUBE DistanceMap : register(s1),
		uniform float3 lastCenter,
		out float4 Color :COLOR0)
{
	
	Color = float4(1,1,1,1);

	//metallic reflection	
	mNormal = normalize(mNormal);
	
	float3 newTexCoord;	
	float3 mPos = wPos - lastCenter;
	float3 V = normalize(wPos - cameraPos);
	float3 R = normalize(reflect( V, mNormal));
		
	newTexCoord = R;	
	
	newTexCoord = Hit(mPos, R, DistanceMap);
	Color = readCubeMap(CubeMap, newTexCoord );		
	
}

void LampGlassPS(  float2 texCoord : TEXCOORD0, 
		float3 wPos	: TEXCOORD1,	
		float3 mNormal  : TEXCOORD2,
		uniform float3 cameraPos,
		uniform samplerCUBE CubeMap : register(s0),
		uniform samplerCUBE DistanceMap : register(s1),
		uniform float3 lastCenter,
		uniform float4 glasColor,
		out float4 Color :COLOR0)
{
	
	Color = float4(1,1,1,1);

	//metallic reflection	
	mNormal = normalize(mNormal);
	
	float3 newTexCoord;	
	float3 mPos = wPos - lastCenter;
	float3 V = normalize(wPos - cameraPos);
	float3 R = normalize(reflect( V, mNormal));
		
	newTexCoord = R;	
	
	newTexCoord = Hit(mPos, R, DistanceMap);
	Color = readCubeMap(CubeMap, newTexCoord );
	Color.a = 1;
	Color *= glasColor;		
	
}