## @package wordCloudHandler
#  
#  Handles the creation of word clouds

import numpy as np
import os
from os import path
from PIL import Image

from wordcloud import WordCloud, STOPWORDS, ImageColorGenerator

## Mask that provides the from and color for the word cloud
wordCloudMask = np.array(Image.open(path.join(path.dirname(__file__) if "__file__" in locals() else os.getcwd(), "data/circle_mask_color.png")))

## generates word clouds for the given supernodes
# @param nodeList List of all nodes
# @param selectedSuperNodes The supernodes that need worClouds
# @param wordCloudAttribute The attribute that is shown in the word cloud
def generateWordClouds(nodeList, selectedSuperNodes, wordCloudAttribute):

    for supernode in selectedSuperNodes:
        nodeIDs = supernode["nodeIds"]
        attributeFrequencies = {}
        for i in nodeIDs:
            nodeAttribute = nodeList[i][wordCloudAttribute]
            for attribute in nodeAttribute:
                attributeFrequencies[attribute] = attributeFrequencies.get(
                    attribute, 0) + 1

        # color = None for transparent
        wc = WordCloud(mode='RGBA', background_color=None,
                       max_words=20, mask=wordCloudMask, color_func=ImageColorGenerator(wordCloudMask))

        wc.generate_from_frequencies(attributeFrequencies)

        wc.to_file("data/wordCloud/" + wordCloudAttribute +
                   "_" + str(supernode["id"]) + ".png")
