/**
 * Main module that starts the client-side application
 * @module Main
 */

var allDataProcessed = false;
var nodes = {};
var castEdges = {};
var keywordsEdges = {};
var genresEdges = {};
var supernodes = [];
var allSupernodes = [];
var lowDetailSuperNodeEdgeMatrices = [];
var lowDetailSuperNodePositionsMultipleEdgeSets = [];
var edgeMatrices = [];

/**
 * starts the client side application.
 * sets up WebGL and the GUI.
 * gets the inital data from the server.
 */
function startApplication() {
    //only run if the browser supports WebGL
    if (WEBGL.isWebGL2Available()) {
        console.log("WebGL supported, starting application");
        // load all node and edge data from server
        $.get("/getData", function (d) {
            try {
                var data = $.parseJSON(d)
                nodes = data['nodes'];
                castEdges = data['castEdges'];
                keywordsEdges = data['keywordsEdges'];
                genresEdges = data['genresEdges'];
                console.log("received node and edge data from server")

                setUpWebGL();
                initGUI();
                // cluster supernodes based on default settings and display its lowDetailLOD
                getSupernodesFromServer(setupNewLowDetailLODAndRender);
            }
            catch (err) {
                console.log(err);
                console.log(d)
            }
        });
    } else {
        var warning = WEBGL.getWebGL2ErrorMessage();
        console.log(warning);
    }
}