/**
 * Provides the WebGL context
 * @module WebGLSetup
 */

var canvas = document.createElement('canvas');
var context = canvas.getContext('webgl2');
const renderer = new THREE.WebGLRenderer({ canvas: canvas, context: context, antialias: true });
var rendering = false;

/**
 * The WebGL Scene
 */
const scene = new THREE.Scene();

/**
 * Texture loader. Used for WordClouds
 */
const loader = new THREE.TextureLoader();

var colorBackground = 0x8A96A3;
var colorWeak = 0xEBBB7C;
var colorLight = 0xCFA172;
var colorMedium = 0x925728;
var colorDark = 0x3D2F28;
var clickedColor;

var outlineMaterial = new THREE.MeshBasicMaterial({ color: colorDark });
var coloredBasicMeshMaterial = new THREE.MeshBasicMaterial({ vertexColors: THREE.FaceColors });

var edgeMaterial = new THREE.LineBasicMaterial({
  vertexColors: THREE.VertexColors,
});

var transparentEdgeMaterial = new THREE.LineBasicMaterial( {
  vertexColors: THREE.VertexColors,
  blending: THREE.AdditiveBlending,
  transparent: true,
  opacity: 0.4
} );

/**
 * sets up the WebGL renderer and the camera
 */
function setUpWebGL() {
  renderer.setSize(window.innerWidth, window.innerHeight);
  renderer.setClearColor (colorBackground, 1);
  document.body.appendChild(renderer.domElement);
  clickedColor = new THREE.Color().set(colorDark);
  setupCamera();
  console.log("WebGL has been set up.")
}

/**
 * render call to refresh scene
 */
function renderScene() {
  rendering = true;
  renderer.render(scene, camera);
  rendering = false;
}