## @package graphLayouting
#  
#  Handles the layouting of the low detail supernode graph

import networkx as nx
import math

## generates the positions of the given supernodes with a spring layout according to the edge weight
#
# the positions are generated for each possible edgeMatrix
# @param supernodes all supernodes
# @param edgeMatrices the lowDetailEdgeMatrices that resulted from the clustering
# @return the supernodes positions for each edgeMatrix
def generateSupernodePositions(supernodes, edgeMatrices):

    positions = {}    
    for edgeMatrixName in edgeMatrices.keys():
        edgeMatrix = edgeMatrices[edgeMatrixName]
        G = nx.Graph()
        initPos = {}
        for i in range(0,len(supernodes)):
            G.add_node(supernodes[i]["id"])
            initPos[i] = (0.5*math.cos(i/len(supernodes)*2*math.pi), 0.5*math.sin(i/len(supernodes)*2*math.pi))

        for i in range(0, len(edgeMatrix)):
            for j in range (i+1, len(edgeMatrix[0])):
                if edgeMatrix[i][j] > 0:
                    G.add_edge(i,j)
                    G[i][j]['weight'] = edgeMatrix[i][j]

        # since 'weight' is the standard node attribute, we do not need to specify it when calculating the positions
        positionDict =  nx.spring_layout(G, pos=initPos, iterations=50, weight = None)
        positionMatrix = []
        for rowIndex in positionDict.keys():
            row = positionDict[rowIndex].tolist()
            positionMatrix.append(row)  

        positions[edgeMatrixName] = positionMatrix

    return positions
