#version 330

in vec2 fUV;
in vec4 shadowCoord;
in vec3 M_position;
in vec3 M_lightDistance;
in vec3 MV_normal;
in vec3 MV_eyeDirection;
in vec3 MV_lightDirection;

out vec4 color;

uniform int colorMode;
uniform vec4 lightColor;
uniform vec4 lightPower;
uniform vec4 uniformColor;
uniform sampler2D colorTexture;
uniform sampler2DShadow shadowMap;

void main()
{
    // Normal of the computed fragment, in camera space
    vec3 n = normalize(MV_normal);

    // Direction of the light (from the fragment to the light)
    vec3 l = normalize(MV_lightDirection);

    // Cosine of the angle between the normal and the light direction,
    // clamped above 0
    //  - light is at the vertical of the triangle -> 1
    //  - light is perpendicular to the triangle -> 0
    //  - light is behind the triangle -> 0
    float cosTheta = clamp(dot(n, l), 0, 1);

    vec4 materialDiffuseColor;
    switch(colorMode) {
        case 0:
        materialDiffuseColor = vec4(1.0, 1.0, 1.0, 1.0);
        break;
        case 1:
        materialDiffuseColor = vec4(texture(colorTexture, fUV).rgb, 1.0);
        break;
        case 2:
        materialDiffuseColor = uniformColor;
        break;
        case 3:
        materialDiffuseColor = vec4(M_position.z, 1.0 - M_position.z, 0.0, 1.0);
        break;
        case 4:
        materialDiffuseColor = vec4(texture(colorTexture, fUV).rgb, 0.5);
        break;
        default:
        materialDiffuseColor = vec4(1.0, 1.0, 1.0, 1.0);
        break;
    }
    vec4 materialAmbientColor = vec4(0.1,0.1,0.1, 1.0) * materialDiffuseColor;

    float bias = 0.005;
    float visibility = texture(shadowMap, vec3(shadowCoord.x, shadowCoord.y, shadowCoord.z - bias));

    color = materialAmbientColor +
            visibility * materialDiffuseColor * lightColor * lightPower * cosTheta / M_lightDistance.x;
}
