//Rendert einen einzelnen Slice des Volumes
//Gradienten werden aus dem Volumen gesampled
//Pixel werden anhand der Transferfunktion eingefrbt
//Diffuses Beleuchtungsmodell mithilfe einer Lichtquelle an einer fixen Position

SamplerState TrilinearSampler : register(s0);

cbuffer cbProjection : register(b0)
{
    matrix Model;
    matrix View;
    matrix Projection;
	matrix Normalize;
}

cbuffer cbPerFrame : register (b1)
{
	float Alpha;
}

Texture3D<float4> VolumeTexture : register(t0);
Texture1D<float4> TransferTexture : register(t1);

struct VertexShaderInput
{
    float4 Position : POSITION0;
};

struct VertexShaderOutput
{
    float4 Position : SV_POSITION;
	float3 VaryingPos : TEXCOORD0;
};

VertexShaderOutput VertexShaderFunction(VertexShaderInput input)
{
	VertexShaderOutput output = (VertexShaderOutput)0;
	
	float4 worldPosition = mul( input.Position, Model);
	float4 viewPosition = mul( worldPosition, View );
	output.Position = mul( viewPosition, Projection );

	output.VaryingPos = mul(input.Position, Normalize);
	
	return output;
}

float4 PixelShaderFunction(VertexShaderOutput input) : SV_Target
{
	float4 vol = VolumeTexture.Sample(TrilinearSampler, float4(input.VaryingPos,0)).rgba;
	float4 color = TransferTexture.Sample(TrilinearSampler, vol.a);
	color.a = color.a * Alpha/100.0;
	float3 grad = vol.xyz;

	float3 lightpos = float3(0.0f,5.0f,5.0f);

	float diff = clamp(dot(grad, lightpos), 0, 1);

	color.rgb = diff * color.rgb + 0.3f * color.rgb;

    return color;
}
