// Berechnet Gradienten anhand der CentralDifference-Implementierung
// Referenz: http://christian.mendl.net/pages/software.html

Texture3D<float> volume : register(t0);
RWTexture3D<float4> gradient : register(u0);

[numthreads(8, 8, 8)]
void ComputeGradient(uint3 threadID : SV_DispatchThreadID)
{
	float3 cdiff = -float3(
		volume[threadID + uint3(1,0,0)] - volume[threadID - uint3(1,0,0)],
		volume[threadID + uint3(0,1,0)] - volume[threadID - uint3(0,1,0)],
		volume[threadID + uint3(0,0,1)] - volume[threadID - uint3(0,0,1)]);
	
	float l = length(cdiff);

	if(l == 0)
		cdiff = float3(0,0,0);
	else
		cdiff = cdiff / l;

	gradient[threadID] = float4(cdiff, volume[threadID]);
}
