//Blendet den Intermediate-Buffer ber den Eye-Buffer (OVER) und rendert ein FullScreen-Quad

SamplerState TrilinearSampler : register(s0);

Texture2D<float4> EyeBuffer : register(t2);
Texture2D<float4> IntermediateBuffer : register(t3);

struct VertexShaderInput
{
    uint vertexId : SV_VERTEXID;
};

struct VertexShaderOutput
{
    float4 pos : SV_POSITION;
	float2 tex : TEXCOORD0;
};

VertexShaderOutput VertexShaderFunction(VertexShaderInput input)
{
	VertexShaderOutput output = (VertexShaderOutput)0.0;

	output.tex = float2((input.vertexId << 1) & 2, input.vertexId & 2);
	output.pos = float4(output.tex * float2(2.0, -2.0) + float2(-1.0, 1.0), 0.0, 1.0);

	return output;
}

float4 PixelShaderFunction(VertexShaderOutput input) : SV_Target
{
	float4 source = EyeBuffer.Sample(TrilinearSampler, input.tex);
	float4 dest = IntermediateBuffer.Sample(TrilinearSampler, input.tex);
	
	return dest + source*(1-dest.a);
}