// Filtert Gradienten mit einem 3x3x3 Gauss-Filter
// Referenz: http://christian.mendl.net/pages/software.html

#pragma pack_matrix(row_major)

Texture3D<float4> input : register(t0);
RWTexture3D<float4> output : register(u0);

static const float w[3][3][3] = {
	{ { 0.0205863, 0.033941,  0.0205863 }, { 0.033941,  0.0559593, 0.033941  }, { 0.0205863, 0.033941, 0.0205863 } },
	{ { 0.033941,  0.0559593, 0.033941  }, { 0.0559593, 0.0922613, 0.0559593 }, { 0.033941, 0.0559593, 0.033941  } },
	{ { 0.0205863, 0.033941,  0.0205863 }, { 0.033941,  0.0559593, 0.033941  }, { 0.0205863, 0.033941, 0.0205863 } } };

[numthreads(8, 8, 8)]
void Filter(uint3 threadID : SV_DispatchThreadID)
{
	float3 result = float3(0, 0, 0);

	for (uint i = 0; i < 3; i++) {
		for (uint j = 0; j < 3; j++) {
			for (uint k = 0; k < 3; k++) {
				result += w[i][j][k] * input[threadID + uint3(i, j, k) - uint3(1, 1, 1)].xyz;
			}
		}
	}

	output[threadID] = float4(result, input[threadID].w);
}
