//Fgt die einzelnen Slices BTF/FTB zusammen und berechnet den DepthOfField-Effekt
//durch 2x2 Sampling im Circle of Confusion

SamplerState TrilinearSampler : register(s0);

Texture2D<float4> AccumulationBuffer : register(t2);
Texture2D<float4> SliceBuffer : register(t3);

cbuffer cbPerFrame : register (b0)
{
	float2 CoCTex;
	float method;
}

struct VertexShaderInput
{
    uint vertexId : SV_VERTEXID;
};

struct VertexShaderOutput
{
    float4 pos : SV_POSITION;
	float2 tex : TEXCOORD0;
};

VertexShaderOutput VertexShaderFunction(VertexShaderInput input)
{
	VertexShaderOutput output = (VertexShaderOutput)0.0;

	output.tex = float2((input.vertexId << 1) & 2, input.vertexId & 2);
	output.pos = float4(output.tex * float2(2.0, -2.0) + float2(-1.0, 1.0), 0.0, 1.0);

	return output;
}

float4 PixelShaderFunction(VertexShaderOutput input) : SV_Target
{
    float4 curCol = SliceBuffer.Sample(TrilinearSampler, input.tex);

	float2 offset = CoCTex;

	float4 blur_sample = float4(0.0f,0.0f,0.0f,0.0f);

	blur_sample += AccumulationBuffer.SampleLevel(TrilinearSampler, float2(input.tex.x+offset.x,input.tex.y+offset.y),0);
	blur_sample += AccumulationBuffer.SampleLevel(TrilinearSampler, float2(input.tex.x+offset.x,input.tex.y-offset.y),0);
	blur_sample += AccumulationBuffer.SampleLevel(TrilinearSampler, float2(input.tex.x-offset.x,input.tex.y+offset.y),0);
	blur_sample += AccumulationBuffer.SampleLevel(TrilinearSampler, float2(input.tex.x-offset.x,input.tex.y-offset.y),0);
	blur_sample = blur_sample / 4.0f;

	if(method == 0.0f)//btf
	{
		blur_sample = lerp(blur_sample, curCol, curCol.a);
	}
	else//ftb
	{
		curCol.x *= curCol.a;
		curCol.y *= curCol.a;
		curCol.z *= curCol.a;
		
		blur_sample = blur_sample + curCol*(1.0f - blur_sample.a);
	}

	return blur_sample;
}