//Erzeugt einen Wrfel mit VertexColors

cbuffer ConstantBuffer : register( b0 )
{
    matrix Model;
    matrix View;
    matrix Projection;
	matrix Normalize;
}

struct VertexShaderInput
{
    float4 Position : POSITION0;
	float4 Color : COLOR0;
};

struct VertexShaderOutput
{
    float4 Position : SV_POSITION;
	float4 Color : COLOR0;
};

VertexShaderOutput VertexShaderFunction(VertexShaderInput input)
{
	VertexShaderOutput output = (VertexShaderOutput)0;
	
	float4 worldPosition = mul( input.Position, Model );
	float4 viewPosition = mul( worldPosition, View );
	output.Position = mul( viewPosition, Projection );
	output.Color = input.Color;

	return output;
}

float4 PixelShaderFunction(VertexShaderOutput input) : SV_TARGET
{
    return input.Color;
}
