﻿using SharpDX.Direct3D11;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace VoluRen
{
    /// <summary>
    /// Singleton
    /// Management-Klasse verwaltet die States, welche für das Rendering benötigt werden
    /// z.B. BlendState, SamplerState, RasterizerState
    /// </summary>
    public class StateManagement
    {
        private static StateManagement _instance;

        private StateManagement()
        {
            #region sampler
            SamplerLinearClamp = new SamplerStateDescription()
            {
                Filter = Filter.MinMagMipLinear,
                AddressU = TextureAddressMode.Clamp,
                AddressV = TextureAddressMode.Clamp,
                AddressW = TextureAddressMode.Clamp,
            };
            #endregion

            #region blendstates
            RTOpaque = new RenderTargetBlendDescription()
            {
                IsBlendEnabled = true,
                SourceBlend = BlendOption.One,
                DestinationBlend = BlendOption.Zero,
                BlendOperation = SharpDX.Direct3D11.BlendOperation.Add,
                SourceAlphaBlend = BlendOption.One,
                DestinationAlphaBlend = BlendOption.Zero,
                AlphaBlendOperation = SharpDX.Direct3D11.BlendOperation.Add,
                RenderTargetWriteMask = ColorWriteMaskFlags.All,
            };
            Opaque = new BlendStateDescription()
            {
                AlphaToCoverageEnable = false,
            };

            RTBackToFront = new RenderTargetBlendDescription()
            {
                IsBlendEnabled = true,
                SourceBlend = BlendOption.SourceAlpha,
                DestinationBlend = BlendOption.InverseSourceAlpha,
                BlendOperation = SharpDX.Direct3D11.BlendOperation.Add,
                SourceAlphaBlend = BlendOption.SourceAlpha,
                DestinationAlphaBlend = BlendOption.InverseSourceAlpha,
                AlphaBlendOperation = SharpDX.Direct3D11.BlendOperation.Add,
                RenderTargetWriteMask = ColorWriteMaskFlags.All,
            };
            BackToFront = new BlendStateDescription()
            {
                AlphaToCoverageEnable = false,
            };

            #endregion

            #region rasterstates
            RCullNoneSolid = new RasterizerStateDescription()
            {
                CullMode = CullMode.None,
                FillMode = FillMode.Solid,
                IsAntialiasedLineEnabled = false,
                IsMultisampleEnabled = false,
                SlopeScaledDepthBias = 0.0f,
                DepthBias = 0,
                IsFrontCounterClockwise = true,
            };

            RCullBackWireframe = new RasterizerStateDescription()
            {
                CullMode = CullMode.Back,
                FillMode = FillMode.Wireframe,
                IsAntialiasedLineEnabled = false,
                IsMultisampleEnabled = false,
                SlopeScaledDepthBias = 0.0f,
                DepthBias = 0,
                IsFrontCounterClockwise = true,
            };

            RCullBackSolid = new RasterizerStateDescription()
            {
                CullMode = CullMode.Back,
                FillMode = FillMode.Solid,
                IsAntialiasedLineEnabled = true,
                IsMultisampleEnabled = true,
                SlopeScaledDepthBias = 0.0f,
                DepthBias = 0,
                IsFrontCounterClockwise = true,
            };
            #endregion
        }

        /// <summary>
        /// Liefert die einzige Instanz der Klasse
        /// </summary>
        public static StateManagement Instance
        {
            get 
            {
                if (_instance == null)
                {
                    _instance = new StateManagement();
                }
                return _instance;
            }
        }

        /// <summary>
        /// RasterizerState: Solid, kein Culling (get)
        /// </summary>
        public RasterizerStateDescription RCullNoneSolid
        {
            get;
            private set;
        }

        /// <summary>
        /// RasterizerState: Wireframe, Backface-Culling (get)
        /// </summary>
        public RasterizerStateDescription RCullBackWireframe
        {
            get;
            private set;
        }

        /// <summary>
        /// RasterizerState: Solid, Backface-Culling (get)
        /// </summary>
        public RasterizerStateDescription RCullBackSolid
        {
            get;
            private set;
        }

        /// <summary>
        /// SamplerState: Trilinear, Clamp Borders (get)
        /// </summary>
        public SamplerStateDescription SamplerLinearClamp
        {
            get;
            private set;
        }

        /// <summary>
        /// RenderTarget-BlendState: Opaque (get)
        /// </summary>
        public RenderTargetBlendDescription RTOpaque
        {
            get;
            private set;
        }

        /// <summary>
        /// BlendState: Opaque (get)
        /// </summary>
        public BlendStateDescription Opaque
        {
            get;
            private set;
        }

        /// <summary>
        /// RenderTarget-BlendState: BackToFront-Compositing (get)
        /// </summary>
        public RenderTargetBlendDescription RTBackToFront
        {
            get;
            private set;
        }

        /// <summary>
        /// BlendState: BackToFront-Compositing (get)
        /// </summary>
        public BlendStateDescription BackToFront
        {
            get;
            private set;
        }
    }
}
