﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using System.Windows.Forms;
using SharpDX.Windows;

namespace VoluRen
{
    /// <summary>
    /// Enthält den EntryPoint der Anwendung (static void Main())
    /// </summary>
    static class Launcher
    {
        /// <summary>
        /// EntryPoint der Anwendung. Enthält die RenderLoop und schleift den Render-Aufruf an die MainForm durch
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            MainForm form = new MainForm();
            RenderLoop.RenderCallback callback = new RenderLoop.RenderCallback(form.Render);
            RenderLoop.Run(form, () =>
            {
                form.Render();
            });

            form.CleanUp();
        }
    }
}
