﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Drawing;

using SharpDX;

namespace VoluRen
{
    /// <summary>
    /// Singleton
    /// Management-Klasse, welche die Usereingaben speichert und verwaltet
    /// </summary>
    public class InputManagement
    {
        private static InputManagement _instance;

        private Point _mousePosition;
        private Vector2 _mouseDelta;

        private InputManagement()
        {
            _mousePosition = Cursor.Position;
            _mouseDelta = Vector2.Zero;
            FocusPlanePosition = 0.5f;
            Alpha = 5;
        }

        /// <summary>
        /// Liefert die einzige Instanz der Klasse
        /// </summary>
        public static InputManagement Instance
        {
            get
            {
                if (_instance == null)
                {
                    _instance = new InputManagement();
                }
                return _instance;
            }
        }

        /// <summary>
        /// Updated die Eingaben, welche im aktuellen Frame getätigt wurden
        /// Mouse-Input, Tastatur-Input
        /// </summary>
        /// <param name="keyPressed">Betätigte Tastatureingabe</param>
        public void Update(Keys keyPressed)
        {
            _mouseDelta.X = Cursor.Position.X - _mousePosition.X;
            _mouseDelta.Y = Cursor.Position.Y - _mousePosition.Y;

            _mousePosition.X = Cursor.Position.X;
            _mousePosition.Y = Cursor.Position.Y;

            KeyPressed = keyPressed;
        }

        /// <summary>
        /// Maus-Veränderung im aktuellen Frame (get/set)
        /// </summary>
        public Vector2 MouseDelta { get { return _mouseDelta; } set { _mouseDelta = value; } }

        /// <summary>
        /// Tastatureingabe im aktuellen Frame (get/set)
        /// </summary>
        public Keys KeyPressed { get; private set; }

        /// <summary>
        /// FocusPlane-Position (über Slider im GUI) (get/set)
        /// </summary>
        public float FocusPlanePosition { get; set; }

        /// <summary>
        /// Alpha-Wert (über Slider im GUI) (get/set)
        /// </summary>
        public int Alpha { get; set; }

        /// <summary>
        /// Depth Of Field aktiviert/deaktiviert (über Checkbox im GUI) (get/set)
        /// </summary>
        public bool EnableDOF { get; set; }

        /// <summary>
        /// Blur (über Slider im GUI) (get/set)
        /// </summary>
        public float R { get; set; }

        /// <summary>
        /// BoundingBox aktivieren/deaktivieren (über Checkbox im GUI) (get/set)
        /// </summary>
        public bool DrawBB { get; set; }
    }
}
