﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using System.Windows.Forms;
using MetroFramework.Forms;

namespace VoluRen
{
    /// <summary>
    /// Form, über die Volumendaten geladen werden
    /// </summary>
    public partial class FileLoaderForm : MetroForm
    {
        private const string DUMMY_IMG = "resources\\voluren.jpg";
        private VolumeManagement.VolumeMetaData _selectedVolume;

        /// <summary>
        /// Konstruktor, erzeugt das Fensterobjekt
        /// </summary>
        public FileLoaderForm()
        {
            InitializeComponent();
        }

        private void FileLoaderForm_Load(object sender, EventArgs e)
        {
            _selectedVolume = null;

            ImageList il = new ImageList();
            List<String> namelist = new List<string>();

            il.ImageSize = new Size(48, 48);

            foreach (string volfile in GetFiles("resources\\volumes", "*.raw", SearchOption.TopDirectoryOnly))
            {
                string imgname = "resources\\volumes\\" + Path.GetFileNameWithoutExtension(volfile) + ".jpg";

                if (File.Exists(imgname))
                {
                    il.Images.Add(Image.FromFile(imgname));
                }
                else
                    il.Images.Add(Image.FromFile(DUMMY_IMG));

                namelist.Add(volfile);
            }

            _listView.View = View.Tile;
            _listView.LargeImageList = il;
            _listView.TileSize = new Size(_listView.Size.Width - 4, 48);
            _listView.Font = new Font("Open Sans Light", 12, FontStyle.Regular, GraphicsUnit.Point);

            for (int i = 0; i < il.Images.Count; i++)
            {
                ListViewItem lvi = new ListViewItem();
                lvi.ImageIndex = i;
                lvi.Text = Path.GetFileNameWithoutExtension(namelist[i]);

                int idx = lvi.Text.LastIndexOf("_") + 1;
                String sizestr = lvi.Text.Substring(idx, lvi.Text.Length - idx);
                string[] sizes = sizestr.Split('x');
                lvi.Tag = new string[] { namelist[i], sizes[0], sizes[1], sizes[2] };
                _listView.Items.Add(lvi);
            }
        }

        /// <summary>
        /// Holt die Metadaten des ausgewählten Volumes
        /// </summary>
        /// <returns>Volumen-Metadaten</returns>
        public VolumeManagement.VolumeMetaData GetSelectedVolume()
        {
            return _selectedVolume;
        }

        private void metroButton1_Click(object sender, EventArgs e)
        {
            _selectedVolume = null;
            this.Close();
        }

        private void metroButton2_Click(object sender, EventArgs e)
        {
            _selectedVolume = null;

            if (_listView.SelectedItems.Count > 0)
            {
                string[] file = (string[])_listView.SelectedItems[0].Tag;
                _selectedVolume = new VolumeManagement.VolumeMetaData(_listView.SelectedIndices[0], file[0], Int32.Parse(file[1]), Int32.Parse(file[2]), Int32.Parse(file[3]));
            }

            this.Close();
        }

        private static string[] GetFiles(string path, string searchPattern, SearchOption searchOption)
        {
            string[] searchPatterns = searchPattern.Split('|');
            List<string> files = new List<string>();
            foreach (string sp in searchPatterns)
                files.AddRange(System.IO.Directory.GetFiles(path, sp, searchOption));
            files.Sort();
            return files.ToArray();
        }
    }
}
