﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using SharpDX.D3DCompiler;
using SharpDX.Direct3D;
using SharpDX.Direct3D11;
using SharpDX.DXGI;
using Device = SharpDX.Direct3D11.Device;
using System.Runtime.InteropServices;
using SharpDX;

namespace VoluRen
{
    /// <summary>
    /// Testklasse, Rendert einen eingefärbten Würfel
    /// wird vom Programm nicht verwendet
    /// </summary>
    public class ColorCubeRenderer : IRenderer
    {
        private VertexShader g_pVertexShader;
        private PixelShader g_pPixelShader;

        private BufferWrapper<Projections> _constantBuffer;
        private BufferWrapper<StructVertexColor> _vertexBufferWrapper;
        private BufferWrapper<ushort> _indexBufferWrapper;

        private Device _device;
        private Camera _camera;

        private BoundingBox _boundingBox;

        private InputLayout _layout;
        private RasterizerState _cullBackState;

        public void Init(Device device, Camera camera)
        {
            _device = device;
            _camera = camera;

            ShaderFlags flags = ShaderFlags.EnableStrictness;
#if DEBUG
            flags |= ShaderFlags.Debug;
#endif
            var pVSBlob = ShaderBytecode.CompileFromFile("resources\\shaders\\ColorCube.hlsl", "VertexShaderFunction", "vs_5_0", flags, EffectFlags.None);
            var inputSignature = ShaderSignature.GetInputSignature(pVSBlob);
            g_pVertexShader = new VertexShader(device, pVSBlob);

            var pPSBlob = ShaderBytecode.CompileFromFile("resources\\shaders\\ColorCube.hlsl", "PixelShaderFunction", "ps_5_0", flags, EffectFlags.None);
            g_pPixelShader = new PixelShader(device, pPSBlob);


            _layout = new InputLayout(device, inputSignature, new[]{
					new InputElement("POSITION", 0, Format.R32G32B32_Float, 0),
                    new InputElement("COLOR",0,Format.R32G32B32A32_Float,12,0),
				});

            pVSBlob.Dispose();
            pPSBlob.Dispose();
            inputSignature.Dispose();

            device.ImmediateContext.InputAssembler.InputLayout = _layout;
   
            _cullBackState = new RasterizerState(_device, StateManagement.Instance.RCullBackSolid);
            _device.ImmediateContext.Rasterizer.State = _cullBackState;

            BufferDescription vertexbufferdesc = new SharpDX.Direct3D11.BufferDescription
            {
                BindFlags = SharpDX.Direct3D11.BindFlags.VertexBuffer | BindFlags.IndexBuffer,
                CpuAccessFlags = SharpDX.Direct3D11.CpuAccessFlags.Write,
                OptionFlags = SharpDX.Direct3D11.ResourceOptionFlags.None,
                StructureByteStride = 0,
                Usage = SharpDX.Direct3D11.ResourceUsage.Dynamic
            };

            _boundingBox = new BoundingBox();
            StructVertexColor[] vertices = new StructVertexColor[(int)BoundingBox.Corner.CornerCOUNT];
            for (int i = 0; i < (int)BoundingBox.Corner.CornerCOUNT; i++)
            {
                vertices[i] = new StructVertexColor();
                vertices[i].Position = _boundingBox.Vertices[i];

                if(i==0)
                    vertices[i].Color = new SharpDX.Color4(1.0f, 0.0f, 0.0f, 1.0f);
                else if(i==7)
                    vertices[i].Color = new SharpDX.Color4(1.0f, 1.0f, 1.0f, 1.0f);
                //else if (i < 6)
                //    vertices[i].Color = new SharpDX.Color4(1.0f, 1.0f, 0.0f, 1.0f);
                else
                    vertices[i].Color = new SharpDX.Color4(0.0f, 0.0f, 1.0f, 1.0f);
            }
            vertexbufferdesc.SizeInBytes = Marshal.SizeOf(typeof(StructVertexColor)) * vertices.Count();

            _vertexBufferWrapper = new BufferWrapper<StructVertexColor>(device, vertexbufferdesc);
            _vertexBufferWrapper.ArrayValue = vertices;
            device.ImmediateContext.InputAssembler.SetVertexBuffers(0, new VertexBufferBinding(_vertexBufferWrapper.Buffer, Marshal.SizeOf(typeof(StructVertexColor)), 0));

            vertexbufferdesc.SizeInBytes = Marshal.SizeOf(typeof(ushort)) * _boundingBox.Indices.Count();
            _indexBufferWrapper = new BufferWrapper<ushort>(device, vertexbufferdesc);
            _indexBufferWrapper.ArrayValue = _boundingBox.Indices;
            device.ImmediateContext.InputAssembler.SetIndexBuffer(_indexBufferWrapper.Buffer, Format.R16_UInt, 0);

            device.ImmediateContext.InputAssembler.PrimitiveTopology = PrimitiveTopology.TriangleList;

            _constantBuffer = new BufferWrapper<Projections>(device);
        }

        public void Draw(TimeEventArgs args)
        {
            _constantBuffer.Value = new Projections()
            {
                Model = Matrix.Transpose(VolumeManagement.Instance.ModelMatrix),
                View = Matrix.Transpose(_camera.ViewMatrix),
                Projection = Matrix.Transpose(_camera.ProjectionMatrix),
            };

            _device.ImmediateContext.VertexShader.Set(g_pVertexShader);
            _device.ImmediateContext.VertexShader.SetConstantBuffer(0, _constantBuffer.Buffer);
            _device.ImmediateContext.PixelShader.Set(g_pPixelShader);
            _device.ImmediateContext.DrawIndexed(36, 0, 0);
        }

        /// <summary>
        /// Disposed die erzeugten DirectX-Objekte
        /// </summary>
        public void Dispose()
        {
            g_pVertexShader.Dispose();
            g_pPixelShader.Dispose();

            _constantBuffer.Dispose();
            _vertexBufferWrapper.Dispose();
            _indexBufferWrapper.Dispose();

            _layout.Dispose();
            _cullBackState.Dispose();

            _device.Dispose();
        }
    }
}
