﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;

namespace VoluRen
{
    /// <summary>
    /// Speichert eine BoundingBox. Wird zum Berechnen der Slices verwendet und zum Zeichnen der Volume-BoundingBox
    /// </summary>
	public class BoundingBox
	{
        /// <summary>
        /// Konstruktor
        /// </summary>
        /// <param name="vertices">Vertices für die Schnittberechnungen (Seitenlänge 2; -1 - +1)</param>
        /// <param name="dvertices">Vertices für das Zeichnen der BoundingBox (Seitenlänge 2,4)</param>
        public BoundingBox(Vector3[] vertices, Vector3[] dvertices)
        {
            Vertices = vertices;

            DrawVertices = dvertices;

            Indices = new ushort[]
		    {
			    0,3,2,0,1,3,	// near
			    1,7,3,1,5,7,	// right
			    5,6,7,5,4,6,	// far
			    4,2,6,4,0,2,	// left
			    4,5,0,5,1,0,	// bottom
			    2,7,6,2,3,7		// top
		    };

            LineIndices = new ushort[]
            {
                0,2,2,3,3,1,1,0,
                0,4,4,6,6,7,7,5,
                5,4,5,1,2,6,3,7
            };
        }

        /// <summary>
        /// Konstruktor
        /// </summary>
        /// <param name="vertices">Vertices für die Schnittberechnungen (Seitenlänge 2; -1 - +1)</param>
        public BoundingBox(Vector3[] vertices)
            : this(vertices,
            new Vector3[]
            {
			    new Vector3(-1.2f,-1.2f,-1.2f),
                new Vector3(1.2f,-1.2f,-1.2f),
                new Vector3(-1.2f,1.2f,-1.2f),
                new Vector3(1.2f,1.2f,-1.2f),
                new Vector3(-1.2f,-1.2f,1.2f),
                new Vector3(1.2f,-1.2f,1.2f),
                new Vector3(-1.2f,1.2f,1.2f),
                new Vector3(1.2f,1.2f,1.2f)
            })
		{
		}

        /// <summary>
        /// Default-Konstruktor
        /// Standard-BoundingBox wird erstellt. Seitenlänge 2 für die Berechnung und 2,4 für das Zeichnen
        /// </summary>
        public BoundingBox()
            : this(new Vector3[]
            {
			    new Vector3(-1.0f,-1.0f,-1.0f),
                new Vector3(1.0f,-1.0f,-1.0f),
                new Vector3(-1.0f,1.0f,-1.0f),
                new Vector3(1.0f,1.0f,-1.0f),
                new Vector3(-1.0f,-1.0f,1.0f),
                new Vector3(1.0f,-1.0f,1.0f),
                new Vector3(-1.0f,1.0f,1.0f),
                new Vector3(1.0f,1.0f,1.0f)
            },
                new Vector3[]
            {
			    new Vector3(-1.2f,-1.2f,-1.2f),
                new Vector3(1.2f,-1.2f,-1.2f),
                new Vector3(-1.2f,1.2f,-1.2f),
                new Vector3(1.2f,1.2f,-1.2f),
                new Vector3(-1.2f,-1.2f,1.2f),
                new Vector3(1.2f,-1.2f,1.2f),
                new Vector3(-1.2f,1.2f,1.2f),
                new Vector3(1.2f,1.2f,1.2f)
            })
        {
        }

        /// <summary>
        /// Vertices für die Schnittberechnungen (get)
        /// </summary>
		public Vector3[] Vertices { get; private set; }

        /// <summary>
        /// Vertices für das Zeichnen der BoundingBox (get)
        /// </summary>
        public Vector3[] DrawVertices { get; private set; }

        /// <summary>
        /// Indices für eine TriangleList (get)
        /// </summary>
        public ushort[] Indices { get; private set; }

        /// <summary>
        /// Indices für eine LineList (get)
        /// </summary>
        public ushort[] LineIndices { get; private set; }

        /// <summary>
        /// Enum zum Durchiterieren der Eckpunkte
        /// </summary>
        public enum Corner
        {
            MinMinMin = 0,
            MaxMinMin,
            MinMaxMin,
            MaxMaxMin,
            MinMinMax,
            MaxMinMax,
            MinMaxMax,
            MaxMaxMax,
            CornerCOUNT
        };
	}
}
