float4x4 World;
float4x4 View;
float4x4 Projection;
Texture2D BackSideBuffer;
Texture2D FrontSideBuffer;
Texture3D VolumeTexture;
float StepSize;
int Iterations;

SamplerState MeshTextureSampler
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

sampler3D VolumeS = sampler_state
{
	Texture = <VolumeTexture>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = LINEAR;
	
	AddressU = Clamp;	
    AddressV = Clamp;	
    AddressW = Clamp;
};


struct VertexShaderInput
{
    float4 Position : POSITION0;

    // TODO: add input channels such as texture
    // coordinates and vertex colors here.
};

struct VertexShaderOutput
{
    float4 Position : POSITION0;
	float4 VaryingPos : COLOR0;
	float4 Pos      : TEXCOORD0;

    // TODO: add vertex shader outputs such as colors and texture
    // coordinates here. These values will automatically be interpolated
    // over the triangle, and provided as input to your pixel shader.
};

VertexShaderOutput VertexShaderFunction(VertexShaderInput input)
{
    VertexShaderOutput output;

    float4 worldPosition = mul(input.Position, World);
    float4 viewPosition = mul(worldPosition, View);
    output.Position = mul(viewPosition, Projection);
	output.VaryingPos = input.Position;
	output.Pos = output.Position;

    // TODO: add your vertex shader code here.

    return output;
}

float4 PixelShaderFunction(VertexShaderOutput input) : COLOR0
{
	float4 flipped = float4(input.Pos.x, -input.Pos.y, input.Pos.z, input.Pos.w);
	float2 texc = ((flipped.xy /flipped.w) + 1) / 2; // find the right place to lookup in the backside buffer
	float4 start = input.VaryingPos; // the start position of the ray is stored in the texturecoordinate
	float4 back_position  =  BackSideBuffer.Sample(MeshTextureSampler,  texc);
	float3 dir = float3(0,0,0);
	dir.x = back_position.x - start.x;
	dir.y = back_position.y - start.y;
	dir.z = back_position.z - start.z;
	float len = length(dir.xyz); // the length from front to back is calculated and used to terminate the ray
	float3 norm_dir = normalize(dir);
	float delta = StepSize;
	float3 delta_dir = norm_dir * delta;
	float delta_dir_len = length(delta_dir);
	float3 vec = start;
	float4 col_acc = float4(0,0,0,0);
	float alpha_acc = 0;
	float length_acc = 0;
	float4 color_sample = float4(0,0,0,0);
	float alpha_sample = 0;

	for(int i = 0; i < Iterations; i++)
	{
		//color_sample = VolumeTexture.Sample(VolumeSampler, vec);
		color_sample = tex3Dlod(VolumeS, float4(vec, 0.0));
		alpha_sample = color_sample.a * StepSize;
		col_acc   += (1.0 - alpha_acc) * color_sample * alpha_sample * 3;
		alpha_acc += alpha_sample;
		vec += delta_dir;
		length_acc += delta_dir_len;

		//col_acc = color_sample;
		//length_acc += delta_dir_len;

		// terminate if opacity > 1 or the ray is outside the volume
		if(length_acc >= len || alpha_acc > 1.0) 
			break; 
	}
 
	return col_acc;
}

technique Technique1
{
    pass Pass1
    {
        // TODO: set renderstates here.

        VertexShader = compile vs_3_0 VertexShaderFunction();
        PixelShader = compile ps_3_0 PixelShaderFunction();
    }
}
