float4x4 World;
float4x4 View;
float4x4 Projection;
Texture3D VolumeTexture;
Texture2D TransferTexture;
int Iterations;
float AlphaFactor;
bool UseGradients;
float3 L;



SamplerState MeshTextureSampler
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

sampler3D VolumeS = sampler_state
{
	Texture = <VolumeTexture>;
	MinFilter = POINT;
	MagFilter = POINT;
	MipFilter = POINT;
	
	AddressU = Clamp;	
    AddressV = Clamp;	
    AddressW = Clamp;
};

sampler1D TransferS = sampler_state
{
	Texture = <TransferTexture>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = LINEAR;
	
	AddressU  = CLAMP;
    AddressV  = CLAMP;
};


// TODO: add effect parameters here.

struct VertexShaderInput
{
    float4 Position : POSITION0;

    // TODO: add input channels such as texture
    // coordinates and vertex colors here.
};

struct VertexShaderOutput
{
    float4 Position : POSITION0;
	float4 VaryingPos : COLOR0;
	float4 Pos      : TEXCOORD0;

    // TODO: add vertex shader outputs such as colors and texture
    // coordinates here. These values will automatically be interpolated
    // over the triangle, and provided as input to your pixel shader.
};

VertexShaderOutput VertexShaderFunction(VertexShaderInput input)
{
    VertexShaderOutput output;

    //float4 worldPosition = mul(input.Position, World);
    //float4 viewPosition = mul(worldPosition, View);
	float4 viewPosition = mul(input.Position, View);
    output.Position = mul(viewPosition, Projection);
	//output.Position = mul(input.Position, Projection);
	output.VaryingPos = input.Position;
	output.Pos = output.Position;

    // TODO: add your vertex shader code here.

    return output;
}

float4 PixelShaderFunction(VertexShaderOutput input) : COLOR0
{

	float alphaWeight = 1.0 / Iterations;

    // TODO: add your pixel shader code here.
	/*float3 vec = input.VaryingPos;
	float4 color_sample = tex3Dlod(VolumeS, float4(vec,0));
	color_sample = tex1Dlod(TransferS, color_sample.a);
	float alpha_sample = color_sample.a * (alphaWeight + AlphaFactor/1000.0); 
	color_sample.rgb = color_sample.rgb * alpha_sample;*/

	float3 vec = input.VaryingPos;
	float4 value = tex3Dlod(VolumeS, float4(vec,0));
	
	float4 src = tex1Dlod(TransferS, value.a);
//	src.a = src.a * (alphaWeight + AlphaFactor/1000.0); 
	src.a = src.a * (alphaWeight + AlphaFactor/10000.0); 

	if(UseGradients)
	{
		float s = dot(value.xyz, L);
		// diffuse shading + 0.1 ambient
		src.rgb = s * src.rgb + 0.1 * src.rgb;
	}

	src.rgb = src.rgb * src.a;



	return src;
}

technique Technique1
{
    pass Pass1
    {
        // TODO: set renderstates here.

        VertexShader = compile vs_3_0 VertexShaderFunction();
        PixelShader = compile ps_3_0 PixelShaderFunction();
    }
}
