Texture2D curSlice;
Texture2D prevSlice;
Texture2D prevAcc;
float4 texel_offset;
//float2 PixelSize;
float2 Ct;
int DoBlur;

sampler2D CurrentSliceSampler = sampler_state
{
	Texture = <curSlice>;
    MipFilter = POINT;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = Clamp;
    AddressV = Clamp;
};

sampler2D PreviousSliceSampler = sampler_state
{
	Texture = <prevSlice>;
    MipFilter = POINT;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = Clamp;
    AddressV = Clamp;
};

sampler2D PreviousAccSampler = sampler_state
{
	Texture = <prevAcc>;
    MipFilter = POINT;
    MinFilter = POINT;
    MagFilter = POINT;
    AddressU = Clamp;
    AddressV = Clamp;
};


float4 final_position(float4 screen_pos)
{
	//float2 texel_offset = float2(-1.0/512.0, 1.0/512.0);
    float4 result = screen_pos;
    result.xy += texel_offset*result.ww;
    return result;
}
 

struct VertexShaderInput
{
    float4 Position : POSITION0;

    // TODO: add input channels such as texture
    // coordinates and vertex colors here.
};

struct VertexShaderOutput
{
    float4 Position : POSITION0;
//	float4 Pos      : TEXCOORD0;
	float2 uv      : TEXCOORD0;

    // TODO: add vertex shader outputs such as colors and texture
    // coordinates here. These values will automatically be interpolated
    // over the triangle, and provided as input to your pixel shader.
};

VertexShaderOutput VertexShaderFunction(VertexShaderInput input)
{
    VertexShaderOutput output;

    //float4 worldPosition = mul(input.Position, World);
    //float4 viewPosition = mul(worldPosition, View);
    //output.Position = mul(viewPosition, Projection);
	output.Position = final_position(input.Position);
	//output.Pos = output.Position;
	output.uv = float2(0.5f, -0.5f) * input.Position + 0.5f.xx;

    // TODO: add your vertex shader code here.

    return output;
}


float4 PixelShaderFunction(VertexShaderOutput input) : COLOR0
{

	//float4 flipped = float4(input.Pos.x, -input.Pos.y, input.Pos.z, input.Pos.w);
	//float2 uv = ((flipped.xy /flipped.w) + 1) / 2; // find the right place to lookup in the backside buffer
	float2 uv = input.uv;
    float4 curCol = tex2D(CurrentSliceSampler, uv);
    //float4 prevCol = tex2D(PreviousSliceSampler, uv);
    float4 accCol = tex2D(PreviousAccSampler, uv);

	//float2 offset = PixelSize.xy;
	float2 offset = float2(0.0, 0.0);
	if (1 == DoBlur)
	{
		offset = Ct; // blur with the Ct matrix
	}

	float4 blur_sample  =		  tex2D(PreviousAccSampler, float2(uv.x + offset.x, uv.y + offset.y));
	blur_sample  =  blur_sample + tex2D(PreviousAccSampler, float2(uv.x - offset.x, uv.y - offset.y));
	blur_sample  =  blur_sample + tex2D(PreviousAccSampler, float2(uv.x + offset.x, uv.y - offset.y));
	blur_sample  =  blur_sample + tex2D(PreviousAccSampler, float2(uv.x - offset.x, uv.y + offset.y));
	blur_sample = blur_sample/4.0;


	float4 sample = curCol + blur_sample;

	return sample;
    

}

technique Technique1
{
    pass Pass1
    {
		VertexShader = compile vs_2_0 VertexShaderFunction();
        PixelShader = compile ps_2_0 PixelShaderFunction();
    }
}
