#include "Macros.fxh"


DECLARE_TEXTURE(Texture, 0);


BEGIN_CONSTANTS
MATRIX_CONSTANTS

    float4x4 MatrixTransform    _vs(c0) _cb(c0);

END_CONSTANTS


void SpriteVertexShader(inout float4 color    : COLOR0,
                        inout float2 texCoord : TEXCOORD0,
                        inout float4 position : SV_Position)
{
    position = mul(position, MatrixTransform);
}


float4 SpritePixelShader(float4 color : COLOR0,
                         float2 texCoord : TEXCOORD0) : SV_Target0
{
	float2 uv = texCoord;

	float3 refcolors[3][4];
	refcolors[0][0] = float3(1, 1, 1);
	refcolors[0][1] = float3(1, 1, 1);
	refcolors[0][2] = float3(1, 1, 1);
	refcolors[0][3] = float3(1, 1, 1);
	refcolors[1][0] = float3(1, 0, 0);
	refcolors[1][1] = float3(0, 1, 0);
	refcolors[1][2] = float3(0, 0, 1);
	refcolors[1][3] = float3(1, 0, 0);
	refcolors[2][0] = float3(0, 0, 0);
	refcolors[2][1] = float3(0, 0, 0);
	refcolors[2][2] = float3(0, 0, 0);
	refcolors[2][3] = float3(0, 0, 0);

	int uidx = uv.x / 4;
	if (uidx < 0) uidx = 0;
	if (uidx >= 3) uidx = 2;

	int vidx = uv.y / 3;
	if (vidx < 0) vidx = 0;
	if (vidx >= 2) vidx = 1;

	float dx = uv.x - 0.25 * uidx / 0.25;
	float dy = uv.y - 0.333333 * vidx / 0.33333;
	float a11 = sqrt(dx*dx + dy*dy);

	dx = 1.0 - dx;
	float a21 = sqrt(dx*dx + dy*dy);

	dy = 1.0 - dy;
	float a22 = sqrt(dx*dx + dy*dy);

	dx = 1.0 - dx;
	float a12 = sqrt(dx*dx + dy*dy);
	
	//return float4(refcolors[vidx][uidx] * a11 + refcolors[vidx + 1][uidx] * a21 + refcolors[vidx + 1][uidx + 1] * a22 + refcolors[vidx][uidx + 1] * a12, 1);
	return float4(1, 0, 0, 1);
}

technique Technique1
{
    pass Pass1
    {
        // TODO: set renderstates here.

        VertexShader = compile vs_3_0 SpriteVertexShader();
        PixelShader = compile ps_3_0 SpritePixelShader();
    }
}
