﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace DOFerVolumeRenderer
{
	class YourPlane
	{

		const int NUMVERTICES = 6;
		private CustomVertex1[] m_planeVertices;
		VertexBuffer m_planeVB = null;
		
		public YourPlane()
		{
			m_planeVertices = new CustomVertex1[NUMVERTICES];

			Vector3 topLeftFront = new Vector3(0.0f, 1.0f, 1.0f);
			Vector3 bottomLeftFront = new Vector3(0.0f, 0.0f, 1.0f);
			Vector3 topRightFront = new Vector3(1.0f, 1.0f, 1.0f);
			Vector3 bottomRightFront = new Vector3(1.0f, 0.0f, 1.0f);
			Vector3 topLeftBack = new Vector3(0.0f, 1.0f, 0.0f);
			Vector3 topRightBack = new Vector3(1.0f, 1.0f, 0.0f);
			Vector3 bottomLeftBack = new Vector3(0.0f, 0.0f, 0.0f);
			Vector3 bottomRightBack = new Vector3(1.0f, 0.0f, 0.0f);

			m_planeVertices[0] = new CustomVertex1(topLeftFront * new Vector3(2, 2, 2) - new Vector3(1, 1, 1));
			m_planeVertices[1] = new CustomVertex1(bottomLeftFront * new Vector3(2, 2, 2) - new Vector3(1, 1, 1));
			m_planeVertices[2] = new CustomVertex1(topRightFront * new Vector3(2, 2, 2) - new Vector3(1, 1, 1));
			m_planeVertices[3] = new CustomVertex1(bottomLeftFront * new Vector3(2, 2, 2) - new Vector3(1, 1, 1));
			m_planeVertices[4] = new CustomVertex1(bottomRightFront * new Vector3(2, 2, 2) - new Vector3(1, 1, 1));
			m_planeVertices[5] = new CustomVertex1(topRightFront * new Vector3(2, 2, 2) - new Vector3(1, 1, 1));
			

		}

		public CustomVertex1[] Vertices { get { return m_planeVertices; } }

		public void GenerateVertexBuffer(Game game)
		{
			m_planeVB = new VertexBuffer(
				game.GraphicsDevice,
				typeof(CustomVertex1),
				NUMVERTICES,
				BufferUsage.None
				);
			m_planeVB.SetData<CustomVertex1>(m_planeVertices);
		}

		public VertexBuffer VertexBuffer { get { return m_planeVB; } }

	}
}
