﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace DOFerVolumeRenderer
{
	public class VolumeRendererSettings : IVolumeRendererSettings
	{
		private float _alphaFactor = 1.0f;

		public float AlphaFactor
		{
			get
			{
				return _alphaFactor;
			}
			set
			{
				_alphaFactor = value;
				if (_alphaFactor < 0f)
					_alphaFactor = 0f;
			}
		}



		private float _blurFactor = 1.0f;

		public float BlurFactor
		{
			get
			{
				return _blurFactor;
			}
			set
			{
				_blurFactor = value;
				if (_blurFactor < 0.2f)
					_blurFactor = 0.2f;
			}
		}


		private bool _blurEnabled = false;

		public bool BlurEnabled
		{
			get
			{
				return _blurEnabled;
			}
			set
			{
				_blurEnabled = value;
			}
		}


		private bool _gradientsEnabled = false;

		public bool GradientsEnabled
		{
			get
			{
				return _gradientsEnabled;
			}
			set
			{
				_gradientsEnabled = value;
			}
		}
	}
}
