using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;


namespace DOFerVolumeRenderer
{
	/// <summary>
	/// This is a game component that implements IUpdateable.
	/// </summary>
	public class InputHelper : Microsoft.Xna.Framework.GameComponent, IInputHelper
	{
		private Game _game;
		private KeyboardState _lastKeyboardState;
		private KeyboardState _currentKeyboardState;
		private MouseState _lastMouseState;
		private MouseState _currentMouseState;

		public InputHelper(Game game)
			: base(game)
		{
			_game = game;
			_lastKeyboardState = new KeyboardState();
			_currentKeyboardState = new KeyboardState();
			_lastMouseState = new MouseState();
			_currentMouseState = new MouseState();
		}

		/// <summary>
		/// Allows the game component to perform any initialization it needs to before starting
		/// to run.  This is where it can query for any required services and load content.
		/// </summary>
		public override void Initialize()
		{
			base.Initialize();
		}

		/// <summary>
		/// Allows the game component to update itself.
		/// </summary>
		/// <param name="gameTime">Provides a snapshot of timing values.</param>
		public override void Update(GameTime gameTime)
		{
			_lastKeyboardState = _currentKeyboardState;
			_currentKeyboardState = Keyboard.GetState();

			_lastMouseState = _currentMouseState;
			_currentMouseState = Mouse.GetState();

			base.Update(gameTime);
		}




		public KeyboardState KeyboardState
		{
			get { return _currentKeyboardState; }
		}

		public bool IsNewKeyPress(Keys key)
		{
			return (_currentKeyboardState.IsKeyDown(key) &&
					_lastKeyboardState.IsKeyUp(key));
		}

		public bool IsNewKeyRelease(Keys key)
		{
			return (_lastKeyboardState.IsKeyDown(key) &&
					_currentKeyboardState.IsKeyUp(key));
		}




		public bool IsNewLMBPress()
		{
			return (_currentMouseState.LeftButton == ButtonState.Pressed &&
					_lastMouseState.LeftButton == ButtonState.Released);
		}

		public bool IsNewRMBPress()
		{
			return (_currentMouseState.RightButton == ButtonState.Pressed &&
					_lastMouseState.RightButton == ButtonState.Released);
		}

		public bool IsNewMMBPress()
		{
			return (_currentMouseState.MiddleButton == ButtonState.Pressed &&
					_lastMouseState.MiddleButton == ButtonState.Released);
		}

		public bool IsNewXBtn1Press()
		{
			return (_currentMouseState.XButton1 == ButtonState.Pressed &&
					_lastMouseState.XButton1 == ButtonState.Released);
		}

		public bool IsNewXBtn2Press()
		{
			return (_currentMouseState.XButton2 == ButtonState.Pressed &&
					_lastMouseState.XButton2 == ButtonState.Released);
		}

		public bool IsNewLMBRelease()
		{
			return (_lastMouseState.LeftButton == ButtonState.Pressed &&
					_currentMouseState.LeftButton == ButtonState.Released);
		}

		public bool IsNewRMBRelease()
		{
			return (_lastMouseState.RightButton == ButtonState.Pressed &&
					_currentMouseState.RightButton == ButtonState.Released);
		}

		public bool IsNewMMBRelease()
		{
			return (_lastMouseState.MiddleButton == ButtonState.Pressed &&
					_currentMouseState.MiddleButton == ButtonState.Released);
		}

		public bool IsNewXBtn1Release()
		{
			return (_lastMouseState.XButton1 == ButtonState.Pressed &&
					_currentMouseState.XButton1 == ButtonState.Released);
		}

		public bool IsNewXBtn2Release()
		{
			return (_lastMouseState.XButton2 == ButtonState.Pressed &&
					_currentMouseState.XButton2 == ButtonState.Released);
		}

		public int ScrollWheelValue
		{
			get { return _currentMouseState.ScrollWheelValue; }
		}

		public int ScrollWheelChange
		{
			get { return _currentMouseState.ScrollWheelValue - _lastMouseState.ScrollWheelValue; }
		}

		public MouseState MouseState
		{
			get { return _currentMouseState; }
		}
	}
}
