﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework;

namespace DOFerVolumeRenderer
{
	public static class ExtensionMethods
	{
		/// <summary>
		/// Maps all ModelMeshParts to the specified effect
		/// </summary>
		/// <param name="model"></param>
		/// <param name="effect"></param>
		public static void RemapModel(this Model model, Effect effect)
		{
			foreach (ModelMesh mesh in model.Meshes)
			{
				foreach (ModelMeshPart part in mesh.MeshParts)
				{
					part.Effect = effect;
				}
			}
		}

        /// <summary>
        /// Calculates the distance from a point to a plane
        /// </summary>
        /// <param name="plane"></param>
        /// <param name="point"></param>
        /// <returns></returns>
        public static float Distance(this Plane plane, Vector3 point)
        {
            float dot = Vector3.Dot(plane.Normal, point);
            float value = dot + plane.D;
            return (float)Math.Abs(value);
        }
	}
}
