﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace DOFerVolumeRenderer
{
	public struct CustomVertex1 : IVertexType
	{
		Vector3 vertexPosition;

		public readonly static VertexDeclaration VertexDeclaration = new VertexDeclaration
		(
			new VertexElement(0, VertexElementFormat.Vector3, VertexElementUsage.Position, 0)
		);

		//The constructor for the custom vertex. This allows similar 
		//initialization of custom vertex arrays as compared to arrays of a 
		//standard vertex type, such as VertexPositionColor.
		public CustomVertex1(Vector3 pos)
		{
			vertexPosition = pos;
		}

		//Public methods for accessing the components of the custom vertex.
		public Vector3 Position
		{
			get { return vertexPosition; }
			set { vertexPosition = value; }
		}
		VertexDeclaration IVertexType.VertexDeclaration
		{
			get { return VertexDeclaration; }
		}
	}

}
