﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;

namespace DOFerVolumeRenderer
{
	public class Cube
	{
		const int NUMVERTICES = 36;
		private CustomVertex1[] m_cubeVertices;
		private Vector3[] m_FICKENCUBE;
		VertexBuffer m_vertexBuffer = null;
		readonly Vector3 m_cubeMin = new Vector3(0, 0, 0);
		readonly Vector3 m_cubeMax = new Vector3(1, 1, 1);
		
		public Cube()
		{

			m_cubeVertices = new CustomVertex1[NUMVERTICES];
			m_FICKENCUBE = new Vector3[8];



			Vector3 topLeftFront = new Vector3(0.0f, 1.0f, 1.0f);
			Vector3 bottomLeftFront = new Vector3(0.0f, 0.0f, 1.0f);
			Vector3 topRightFront = new Vector3(1.0f, 1.0f, 1.0f);
			Vector3 bottomRightFront = new Vector3(1.0f, 0.0f, 1.0f);
			Vector3 topLeftBack = new Vector3(0.0f, 1.0f, 0.0f);
			Vector3 topRightBack = new Vector3(1.0f, 1.0f, 0.0f);
			Vector3 bottomLeftBack = new Vector3(0.0f, 0.0f, 0.0f);
			Vector3 bottomRightBack = new Vector3(1.0f, 0.0f, 0.0f);

			m_FICKENCUBE[0] = topLeftFront;
			m_FICKENCUBE[1] = bottomLeftFront;
			m_FICKENCUBE[2] = topRightFront;
			m_FICKENCUBE[3] = bottomRightFront;
			m_FICKENCUBE[4] = topLeftBack;
			m_FICKENCUBE[5] = topRightBack;
			m_FICKENCUBE[6] = bottomLeftBack;
			m_FICKENCUBE[7] = bottomRightBack;

			// Front face.
			m_cubeVertices[0] = new CustomVertex1(topLeftFront);
			m_cubeVertices[1] = new CustomVertex1(bottomLeftFront);
			m_cubeVertices[2] = new CustomVertex1(topRightFront);
			m_cubeVertices[3] = new CustomVertex1(bottomLeftFront);
			m_cubeVertices[4] = new CustomVertex1(bottomRightFront);
			m_cubeVertices[5] = new CustomVertex1(topRightFront);

			// Back face.
			m_cubeVertices[6] = new CustomVertex1(topLeftBack);
			m_cubeVertices[7] = new CustomVertex1(topRightBack);
			m_cubeVertices[8] = new CustomVertex1(bottomLeftBack);
			m_cubeVertices[9] = new CustomVertex1(bottomLeftBack);
			m_cubeVertices[10] = new CustomVertex1(topRightBack);
			m_cubeVertices[11] = new CustomVertex1(bottomRightBack);

			// Top face.
			m_cubeVertices[12] = new CustomVertex1(topLeftFront);
			m_cubeVertices[13] = new CustomVertex1(topRightBack);
			m_cubeVertices[14] = new CustomVertex1(topLeftBack);
			m_cubeVertices[15] = new CustomVertex1(topLeftFront);
			m_cubeVertices[16] = new CustomVertex1(topRightFront);
			m_cubeVertices[17] = new CustomVertex1(topRightBack);

			// Bottom face. 
			m_cubeVertices[18] = new CustomVertex1(bottomLeftFront);
			m_cubeVertices[19] = new CustomVertex1(bottomLeftBack);
			m_cubeVertices[20] = new CustomVertex1(bottomRightBack);
			m_cubeVertices[21] = new CustomVertex1(bottomLeftFront);
			m_cubeVertices[22] = new CustomVertex1(bottomRightBack);
			m_cubeVertices[23] = new CustomVertex1(bottomRightFront);

			// Left face.
			m_cubeVertices[24] = new CustomVertex1(topLeftFront);
			m_cubeVertices[25] = new CustomVertex1(bottomLeftBack);
			m_cubeVertices[26] = new CustomVertex1(bottomLeftFront);
			m_cubeVertices[27] = new CustomVertex1(topLeftBack);
			m_cubeVertices[28] = new CustomVertex1(bottomLeftBack);
			m_cubeVertices[29] = new CustomVertex1(topLeftFront);

			// Right face.
			m_cubeVertices[30] = new CustomVertex1(topRightFront);
			m_cubeVertices[31] = new CustomVertex1(bottomRightFront);
			m_cubeVertices[32] = new CustomVertex1(bottomRightBack);
			m_cubeVertices[33] = new CustomVertex1(topRightBack);
			m_cubeVertices[34] = new CustomVertex1(topRightFront);
			m_cubeVertices[35] = new CustomVertex1(bottomRightBack);
		}

		public Vector3[] Corners { get { return m_FICKENCUBE; } }
		public CustomVertex1[] Vertices { get { return m_cubeVertices; } }

		public void GenerateVertexBuffer(Game game)
		{
			m_vertexBuffer = new VertexBuffer(
				game.GraphicsDevice,
				typeof(CustomVertex1),
				NUMVERTICES,
				BufferUsage.None
				);
			m_vertexBuffer.SetData<CustomVertex1>(m_cubeVertices);
		}

		public VertexBuffer VertexBuffer { get { return m_vertexBuffer; } }

		public Vector3 MinCoordinates { get { return m_cubeMin; } }
		public Vector3 MaxCoordinates { get { return m_cubeMax; } }
	}
}
