Texture2D txFlow;
Texture1D txTransfer;

int channel;
matrix matView;

SamplerState samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

BlendState SrcAlphaBlendingAdd
{
    BlendEnable[0] = TRUE;
    SrcBlend = SRC_ALPHA;
    DestBlend = ONE;
    BlendOp = ADD;
    SrcBlendAlpha = ZERO;
    DestBlendAlpha = ZERO;
    BlendOpAlpha = ADD;
    RenderTargetWriteMask[0] = 0x0F;
};

struct VS_OUTPUT
{
    float4 Pos : SV_POSITION;
    float2 Tex: TEXCOORD0;
};

VS_OUTPUT VS(float4 pos : POSITION, float2 Tex: TEXCOORD0)
{
    VS_OUTPUT output;
    output.Pos = mul(pos, matView);
    output.Tex = Tex;
    return output;
}

float add, mul;

float4 PS(VS_OUTPUT input) : SV_Target
{	
	float value;
	float3 color;
	  if(channel == 0)
		value = (txFlow.Sample(samLinear, input.Tex).r + add) * mul;
	  else
		if(channel == 1)
			value = (txFlow.Sample(samLinear, input.Tex).g + add) * mul;
		else
			value = (txFlow.Sample(samLinear, input.Tex).b + add) * mul;

	color = txTransfer.Sample(samLinear, value);
	//color = value;
	return float4(color, 1.0f);
}


technique10 Render
{
    pass P0
    {
        SetVertexShader(CompileShader(vs_4_0, VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, PS()));
        //SetBlendState( SrcAlphaBlendingAdd, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
    }
}
