Texture2D txSource, txFlow;
float2 stepSize;

SamplerState samPoint
{
    Filter = MIN_MAG_MIP_POINT;
    AddressU = Clamp;
    AddressV = Clamp;
};

SamplerState samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

BlendState NoAlpha
{
    BlendEnable[0] = FALSE;
};


struct VS_OUTPUT
{
    float4 Pos : SV_POSITION;
    float2 Tex: TEXCOORD0;
};

VS_OUTPUT VS(float4 pos : POSITION)
{
    VS_OUTPUT output;
    output.Pos = pos;
    output.Tex = pos / 2 + 0.5;  // Convert [-1 1] to [0 1]
    output.Tex.y = 1.0f - output.Tex.y;
    return output;
}

float2 PSEuler(VS_OUTPUT input) : SV_Target
{
	 float2 pos = txSource.Sample(samPoint, input.Tex);
	 float2 vel = normalize(txFlow.Sample(samLinear, pos));
	 
	 return pos + vel * stepSize;
}

float2 PSRungeKutter(VS_OUTPUT input) : SV_Target
{
	 float2 pos = txSource.Sample(samPoint, input.Tex);
	 float2 vel = normalize(txFlow.Sample(samLinear, pos));
	 
	 float2 vel2 = normalize(txFlow.Sample(samLinear, pos + vel * stepSize * 0.5f));
	 
	 return pos + (vel + vel2) * 0.5f * stepSize;
}

technique10 Euler
{
    pass P0
    {
        SetVertexShader(CompileShader(vs_4_0, VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, PSEuler()));
        SetBlendState(NoAlpha, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF);
    }
}

technique10 RungeKutter
{
    pass P0
    {
        SetVertexShader(CompileShader(vs_4_0, VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, PSRungeKutter()));
        SetBlendState(NoAlpha, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF);
    }
}