SamplerState samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

BlendState SrcAlphaBlending
{
    BlendEnable[0] = TRUE;
    SrcBlend = SRC_ALPHA;
    DestBlend = INV_SRC_ALPHA;
    BlendOp = ADD;
    SrcBlendAlpha = ONE;
    DestBlendAlpha = ZERO;
    BlendOpAlpha = ADD;
};

float4 color;
matrix matView;

//----------------------------------------------------------

struct VS_OUTPUT
{
    float4 Pos : SV_POSITION;
};

VS_OUTPUT VS(float3 pos : POSITION)
{
    VS_OUTPUT output;
    float3 pos1 = pos *2 - 1.0f;
    output.Pos = mul(float4(pos1.xy, 0.5f, 1.0f), matView);
    return output;
}

float4 PS(VS_OUTPUT input) : SV_Target
{
	  return color;
}

//----------------------------------------------------------

VS_OUTPUT VSTapering(float3 pos : POSITION)
{
    VS_OUTPUT output;
    float3 pos1 = pos *2 - 1.0f;
    output.Pos = mul(float4(pos1.xy, 0.5f, 1.0f), matView);
    output.Pos.z = pos.z;
    return output;
}

[maxvertexcount(6)]
void GSTapering(line VS_OUTPUT input[2], inout TriangleStream<VS_OUTPUT> TriStream)
{
	VS_OUTPUT output;
	output.Pos.z = 0.5f;
	output.Pos.w = 1.0f;
	float2 dir = normalize(input[1].Pos.xy - input[0].Pos.xy);
	dir.yx = dir.xy;
	dir.x = -dir.x;
	
	output.Pos.xy = input[0].Pos.xy + dir * input[0].Pos.z;
	TriStream.Append(output);
	
	output.Pos.xy = input[1].Pos.xy + dir * input[1].Pos.z;
	TriStream.Append(output);
	
	output.Pos.xy = input[0].Pos.xy - dir * input[0].Pos.z;
	TriStream.Append(output);
	
	
	output.Pos.xy = input[1].Pos.xy + dir * input[1].Pos.z;
	TriStream.Append(output);
	
	output.Pos.xy = input[0].Pos.xy - dir * input[0].Pos.z;
	TriStream.Append(output);
	
	output.Pos.xy = input[1].Pos.xy - dir * input[1].Pos.z;
	TriStream.Append(output);

}

//----------------------------------------------------------

float4 glyphColor;
float glyphSize;
uint skipN;

VS_OUTPUT VSGlyphs(float3 pos : POSITION)
{
    VS_OUTPUT output;
    float3 pos1 = pos *2 - 1.0f;
    output.Pos = float4(pos1.xy, 0.5f, 1.0f);
    return output;
}

float4 PSGlyphs(VS_OUTPUT input) : SV_Target
{
	  return glyphColor;
}

[maxvertexcount(3)]
void GSGlyphs(line VS_OUTPUT input[2], in uint id : SV_PrimitiveID, inout TriangleStream<VS_OUTPUT> TriStream)
{
	if((id / skipN) * skipN == id)
	{
		VS_OUTPUT output;
		output.Pos.z = 0.3f;
		output.Pos.w = 1.0f;
		
		float2 dir = normalize(input[1].Pos.xy - input[0].Pos.xy) * glyphSize;
		float2 dir2 = dir.yx / 4;
		dir2.x = -dir2.x;
		
		output.Pos.xy = mul(input[0].Pos.xy + dir2, matView);
		output.Pos.xy += matView[3].xy;
		TriStream.Append(output);
		
		output.Pos.xy = mul(input[0].Pos.xy + dir, matView);
		output.Pos.xy += matView[3].xy;
		TriStream.Append(output);
		
		output.Pos.xy = mul(input[0].Pos.xy - dir2, matView);
		output.Pos.xy += matView[3].xy;
		TriStream.Append(output);
	}

}


//----------------------------------------------------------
struct VS_OUTPUT_TEX_GEN
{
    float4 Pos : SV_POSITION;
    float id : TEXCOORD0;
};

uint numSamples;

VS_OUTPUT_TEX_GEN VSTextureGeneration(float3 pos : POSITION, uint id : SV_VertexID)
{
    VS_OUTPUT_TEX_GEN output;
    float3 pos1 = pos *2 - 1.0f;
    output.Pos = mul(float4(pos1.xy, 0.3f, 1.0f), matView);
    output.id = id;
    return output;
}

float4 PSTextureGeneration(VS_OUTPUT_TEX_GEN input) : SV_Target
{
	  float val = 0.5 * (1 + sin(2 * 3.1415 * input.id / numSamples));
	  return float4(val, val, val, color.a);
}

//----------------------------------------------------------


technique10 Render
{
    pass P0
    {
        SetVertexShader(CompileShader(vs_4_0, VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, PS()));
        SetBlendState( SrcAlphaBlending, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
    }
}

technique10 RenderTapering
{
    pass P0
    {
        SetVertexShader(CompileShader(vs_4_0, VSTapering()));
        SetGeometryShader(CompileShader(gs_4_0, GSTapering()));
        SetPixelShader(CompileShader(ps_4_0, PS()));
        SetBlendState( SrcAlphaBlending, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
    }
}

technique10 RenderGlyphs
{
    pass P0
    {
        SetVertexShader(CompileShader(vs_4_0, VSGlyphs()));
        SetGeometryShader(CompileShader(gs_4_0, GSGlyphs()));
        SetPixelShader(CompileShader(ps_4_0, PSGlyphs()));
        SetBlendState( SrcAlphaBlending, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
    }
}

technique10 RenderTextureGeneration
{
    pass P0
    {
        SetVertexShader(CompileShader(vs_4_0, VSTextureGeneration()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, PSTextureGeneration()));
        SetBlendState( SrcAlphaBlending, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
    }
}
