Texture2D txFlow;
float size;
float3 color;
float alpha;
int useVelocityColor;
int useVelocityScale;
float maxVelocity;
float minVelocity;
matrix matView;

#define PI 3.1415927f
#define PI_HALF 1.5707963

SamplerState samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Clamp;
    AddressV = Clamp;
};

BlendState SrcAlphaBlendingAdd
{
    BlendEnable[0] = TRUE;
    SrcBlend = SRC_ALPHA;
    DestBlend = ONE;
    BlendOp = ADD;
    SrcBlendAlpha = ZERO;
    DestBlendAlpha = ZERO;
    BlendOpAlpha = ADD;
    RenderTargetWriteMask[0] = 0x0F;
};

BlendState SrcAlphaBlending
{
    BlendEnable[0] = TRUE;
    SrcBlend = SRC_ALPHA;
    DestBlend = INV_SRC_ALPHA;
    BlendOp = ADD;
    SrcBlendAlpha = ONE;
    DestBlendAlpha = ZERO;
    BlendOpAlpha = ADD;
   RenderTargetWriteMask[0] = 0x0F;    
};

struct VS_OUTPUT
{
    float4 Pos : SV_POSITION;
    float2 TexCoord: TEXCOORD0;
    float3 Color: COLOR0;
};

VS_OUTPUT VS(float4 Pos : POSITION, float2 Tex: TEXCOORD0)
{
    VS_OUTPUT output;
    output.Pos = mul(Pos, matView);
    output.TexCoord = Tex;
    //output.TexCoord = Pos / 2 + 0.5;  // Convert [-1 1] to [0 1]
    output.Color = color;
    return output;
}

[maxvertexcount(3)]
void GS( point VS_OUTPUT input[1], inout TriangleStream<VS_OUTPUT> TriStream )
{
	VS_OUTPUT output;
	float4 tex = txFlow.SampleLevel (samLinear, input[0].TexCoord, 0);
	float2 vel = float2(tex.x, tex.y);
	float vellength = length(vel);
	//vel /= vellength;
	vel = normalize(vel);
	float angle = acos(vel);
	float velscale = (tex.z-minVelocity) / (maxVelocity-minVelocity);
	
	if (tex.y < 0)
		angle = 2*PI - angle;
	angle = angle - PI_HALF;
	float c = cos(angle);
	float s = sin(angle);
	
	float2x2 matrot = { float2(c, -s), float2(s, c) };
			
	output = input[0];

	if (useVelocityColor != 0)
		output.Color = input[0].Color * velscale;
	
	if (useVelocityScale == 0)
		velscale = 1.0f;
		
	float2 coord = {-.03f, -0.1f};
	float2 coord2 = {.03f, -0.1f};	

	//Scale arrowpoints depending on ArrowSize and Velocity
	coord*=size*velscale;
	coord2*=size*velscale;

	//"Draw" Triangle

	float2 coordTrans = mul(matrot, coord);
	output.Pos.x =  input[0].Pos.x + coordTrans.x;
	output.Pos.y =  input[0].Pos.y + coordTrans.y;

	output.TexCoord = input[0].TexCoord;
	TriStream.Append( output );
		
	output.Pos.x = input[0].Pos.x;
	output.Pos.y = input[0].Pos.y;

	TriStream.Append( output );
	
	coordTrans = mul(matrot, coord2);
	output.Pos.x =  input[0].Pos.x + coordTrans.x;  
	output.Pos.y =  input[0].Pos.y + coordTrans.y;
	TriStream.Append( output );

	TriStream.RestartStrip();
}

float4 PS(VS_OUTPUT input) : SV_Target
{
    return float4(input.Color,alpha);
}


technique10 RenderAlphaBlendingAdd
{
    pass P0
    {  
        SetVertexShader(CompileShader(vs_4_0, VS()));
        SetGeometryShader(CompileShader(gs_4_0, GS()));
        SetPixelShader(CompileShader(ps_4_0, PS()));
        SetBlendState( SrcAlphaBlendingAdd, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
    }
}

technique10 Render
{
    pass P0
    {  
        SetVertexShader(CompileShader(vs_4_0, VS()));
        SetGeometryShader(CompileShader(gs_4_0, GS()));
        SetPixelShader(CompileShader(ps_4_0, PS()));
        SetBlendState( SrcAlphaBlending, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
    }
}
