/**
 * Background.wgsl
 * 
 * Renders a solid color background using the clear color from uniforms.
 * Draws a fullscreen quad without requiring vertex buffer data.
 */

struct UniformData
{
    viewMatrix: mat4x4f,
    projMatrix: mat4x4f,
    camPos: vec4f,
    camDir: vec4f,
    clearColor: vec4f,
    helperLineColor: vec4f,
    kBufferInfo: vec4f,
    
    dirLightDirection: vec4f,
    dirLightColor: vec4f,
    ambLightColor: vec4f,
    materialLightResponse: vec4f,
    
    vertexColorMin: vec4f,
    vertexColorMax: vec4f,
    vertexAlphaBounds: vec4f,
    vertexRadiusBounds: vec4f,
    
    billboardClippingEnabled: u32,
    billboardShadingEnabled: u32,
    vertexColorMode: u32,
    vertexAlphaMode: u32,
    vertexRadiusMode: u32,
    
    vertexAlphaInvert: u32,
    vertexRadiusInvert: u32,
    dataMaxLineLength: f32,
    dataMaxVertexAdjacentLineLength: f32,
}

@group(0) @binding(0) var<uniform> uniforms: UniformData;

struct VertexOutput
{
    @builtin(position) position: vec4f,
    @location(0) screenPos: vec2f,
}

@vertex
fn vs_main(@builtin(vertex_index) vertexID: u32) -> VertexOutput
{
    var positions = array<vec2f, 6>(
        vec2f(0.0, 0.0),
        vec2f(0.0, 1.0),
        vec2f(1.0, 1.0),
        vec2f(1.0, 1.0),
        vec2f(1.0, 0.0),
        vec2f(0.0, 0.0)
    );
    
    var output: VertexOutput;
    let pos = positions[vertexID];
    output.position = vec4f(pos * 2.0 - 1.0, 0.0, 1.0);
    output.screenPos = pos;
    return output;
}

@fragment
fn fs_main(input: VertexOutput) -> @location(0) vec4f
{
    return vec4f(uniforms.clearColor.rgb, 1.0);
}