

#version 430 core

--Vertex 
layout (location = 0) in vec3 aPos;

out vec3 TexCoords;


uniform mat4 projection;
uniform mat4 view;


void main()
{
    TexCoords = aPos;
    mat4 view_transformed = mat4(mat3(view));
    vec4 pos = projection * view_transformed * vec4(aPos, 1.0);
    gl_Position = pos.xyww;
}  

--Fragment
out vec4 FragColor;

in vec3 TexCoords;

uniform samplerCube skybox;
uniform sampler2D skybox_buffer;

layout(location = 0) out vec4 skybox_texture_write;

void main()
{    
    vec4 col = texture(skybox, TexCoords).rgba;
    FragColor = vec4(col.r, col.g, col.b, 1.0);
    //skybox_texture_write = vec4(col.rgb, 1.0);
}
