-- Vertex

#extension GL_ARB_explicit_attrib_location : enable

layout(location = 0) in vec3 vertex;

out vec2 texCoord;

void main()
{
	// [0, 1] normalization for the x-coordinate and y-coordinate to retrieve the x-texcoord and y-texcoord: x(i) - min / max - min, min = -1, max = 1

	float x = (vertex.x + 1.0) / (1.0 + 1.0);
	float y = (vertex.y + 1.0) / (1.0 + 1.0);
	texCoord = vec2(x, y);
	gl_Position = vec4(vertex, 1.0);
}

-- Fragment

uniform sampler2D frontFaces;
uniform sampler2D backFaces;
uniform sampler3D volume;

uniform int renderingMode;

in vec2 texCoord;
out vec4 fragColor;

void main()
{
	// ToDo
	
	
	switch(renderingMode)
	{
		case 0: //render front faces
		{
			fragColor = vec4(texture(frontFaces, texCoord).rgb, 1);
			break;
		}
		
		case 1: //render back faces
		{
			fragColor = vec4(texture(backFaces, texCoord).rgb, 1);
			break;
		}
		
		case 2: //render volume (MIP)
		{
			// compute Ray and RayLength
			vec3 Ray = texture(backFaces, texCoord).rgb - texture(frontFaces, texCoord).rgb;
			float RayLength = sqrt(Ray.x * Ray.x + Ray.y * Ray.y + Ray.z * Ray.z);

			vec3 currentPosition = texture(frontFaces, texCoord).rgb;
			float maxValue = 0.0;
			float temp = 0.0;
			float stepsize = 0.005;
			float sampleCount = RayLength / stepsize;
			vec3 stepVector = (1 / sampleCount * (Ray));

			for (float i = 0.0; i < sampleCount; i = i + 1) {
				currentPosition = currentPosition + stepVector;
				temp = texture(volume, currentPosition).r;
				if (temp > maxValue) {
					maxValue = temp;
				}
			}

			fragColor = vec4(maxValue, maxValue, maxValue, 1);

			break;
		}
		case 3: //render volume (Alpha-Compositing)
		{
			// compute Ray and RayLength
			vec3 Ray = texture(backFaces, texCoord).rgb - texture(frontFaces, texCoord).rgb;
			float RayLength = sqrt(Ray.x * Ray.x + Ray.y * Ray.y + Ray.z * Ray.z);

			vec3 currentPosition = texture(frontFaces, texCoord).rgb;
			float stepsize = 0.005;
			float sampleCount = RayLength / stepsize;
			vec3 stepVector = (1 / sampleCount * (Ray));

			vec4 colSum = vec4(0.0, 0.0, 0.0, 0.0);
			float alpha = 0.0;
			float density = 0.0;
			float densitySum = 0.0;

			for (float i = 0.0; i < sampleCount; i = i + 1) {
				currentPosition = currentPosition + stepVector;
				density = texture(volume, currentPosition).r;

				// break if one of the coordinates is already 1.
				if (colSum.x >= 1.0 || colSum.y >= 1.0 || colSum.z >= 1.0 || colSum.a >= 1.0) {
					break;
				}

				// fixed transer function
				if (density > 0.01 && density < 0.25) {
					alpha = 0.005; //0.005 for head, 0.05 for beetle
					colSum = alpha * vec4(0.2, 0.2, 0.2, alpha) + (1 - alpha) * colSum;
				}
				if (density >= 0.25 && density < 0.50) {
					alpha = 0.01; //0.01 for head, 0.1 for beetle
					colSum = alpha * vec4(0.7, 0.4, 0.4, alpha) + (1 - alpha) * colSum;
				}
				if (density >= 0.50 && density < 0.75) {
					alpha = 0.05; //0.05 for head, 0.15 for beetle
					colSum = alpha * vec4(0.7, 0.75, 0.6, alpha) + (1 - alpha) * colSum;
				}
				if (density >= 0.75 && density <= 1.0) {
					alpha = 0.1; //0.1 for head, 0.2 for beetle
					colSum = alpha * vec4(0.9, 0.9, 0.9, alpha) + (1 - alpha) * colSum;
				}
			}
			fragColor = colSum;
			break;
		}
	}
}