//COMPUTE SHADER FOR INITIALIZING THE BUFFERS
//TODO: -clear color and medium buffers
//      -calculate viewing ray directions, and initial positions based on the viewing transformation matrix
//      -initialize the light and light direction buffers with the color in viewing coordinates
//! Directions and positions are stored in viewing coordinates

#version 450 core

--Compute

layout(binding = 0, rgba32f) uniform image2DArray color_buffer;
layout(binding = 1, rgba32f) uniform image2DArray medium_color_buffer;
layout(binding = 2, rgba32f) uniform image2DArray viewray_pos_buffer;
layout(binding = 3, rgba32f) uniform image2DArray viewray_dir_buffer;
layout(binding = 4, rgba32f) uniform image2DArray light_color_buffer;
layout(binding = 5, rgba32f) uniform image2DArray light_dir_buffer;
layout(binding = 6, rgba32f) uniform image2DArray debug_buffer;

uniform mat4 viewMatrix; //camera view transform matrix
uniform mat4 inverseViewMatrix;
uniform mat4 viewProjMatrix;
uniform mat4 projMatrix;
uniform vec3 viewPos;    //camera position
uniform vec3 viewDir;    //camera look direction
uniform vec3 lightCol;
uniform vec3 lightDir;
uniform vec3 firstPlanePos; // viewspace
uniform vec3 origin; // viewspace
uniform float camera_zoom;

uniform float farPlane;
uniform float fov;
uniform int imageWidth;
uniform int imageHeight;
uniform float aspectRatio;

struct Ray {
    vec3 Origin;
    vec3 Dir;
};


#define PI 3.1415926535897932384626433832795

layout(local_size_x = 16, local_size_y = 16) in; // size of local work group


void main()
{
    // gl_globalInvocationID = gl_WorkGroupID * gl_WorkGroupSize + gl_LocalInvocationID
    ivec3 storePos = ivec3(gl_GlobalInvocationID.xyz);

    // http://wili.cc/blog/opengl-cs.html

    // clear color buffer
    imageStore(color_buffer, storePos, vec4(0.0));

    // clear medium color buffer
    imageStore(medium_color_buffer, storePos, vec4(1.0));

    float offset = 0.5; // take offset to center volume when rendering
    vec3 pos = vec3(storePos.x / float(imageWidth * 0.5) - 1.0, storePos.y / float(imageHeight * 0.5) - 1.0, 1.0) + origin;
    //float x = storePos.x / float(imageWidth * 0.5) - 1.0;
    //float y = storePos.y / float(imageHeight * 0.5) - 1.0;
    imageStore(viewray_pos_buffer, storePos, vec4(camera_zoom * pos.xy, pos.z, 1));
    //imageStore(viewray_pos_buffer, storePos, vec4(pos.xy, pos.z, 1));

    // calculate view ray position with viewing transformation matrix
    
    // https://www.scratchapixel.com/lessons/3d-basic-rendering/ray-tracing-generating-camera-rays/generating-camera-rays
    //float aspecRatio = imageWidth / float(imageHeight); // assume width > height
    float Px = (2.0 * pos.x) * tan(fov / 2.0 * PI / 180.0) * aspectRatio;
    float Py = (2.0 * pos.y) * tan(fov / 2.0 * PI / 180.0);
    vec3 rayOrigin = vec3(0);
    vec3 viewRayDirection = vec3(Px, Py, -1) - rayOrigin;
    viewRayDirection = normalize(viewRayDirection);
    //vec3 viewRayDirection = vec3(0, 0, -1);
    //viewDirection.z *= -1.0;
    imageStore(viewray_dir_buffer, storePos, vec4(0, 0, -1, 0)); // viewing along the the negativ z axis (forward) in viewing coordinates
    //imageStore(viewray_dir_buffer, storePos, vec4(viewRayDirection, 0)); // viewing along the the negativ z axis (forward) in viewing coordinates

    // set light color
    // TODO: add uniform "lightcolor"
    imageStore(light_color_buffer, storePos, vec4(lightCol, 1));

    // set light direction (in viewing coordinates)
    //vec4 lightDirTransformed = viewMatrix * vec4(lightDir, 0);
    vec3 lightDirection = normalize(lightDir);
    //vec3 lightDirection = normalize(vec3(Px, Py, -1) - vec3(-1, 1, 0));
    imageStore(light_dir_buffer, storePos, vec4(lightDirection.xyz, 0));

    imageStore(debug_buffer, storePos, vec4(1.0));
}
