// https://www.cg.tuwien.ac.at/courses/RTVis/material/02%20-%20RTVis%20-%20Real-Time%20Volume%20Graphics%201.pdf

#version 450 core

--Compute

// https://www.cg.informatik.uni-siegen.de/data/Tutorials/EG2006/RTVG05_TransferFunctions.pdf Folie 34
// 
// https://raphaelmenges.github.io/assets/theses/raphaelmenges_bachelor.pdf seite 43...


layout(local_size_x = 1, local_size_y = 1) in; // size of local work group

layout(rgba8) uniform image2D preintTable;
uniform vec4 controlPoints[4];

vec4 interpPoints[256];
vec4 preIntegration[256];

void numIntegration();
void storeIntoTable();

// integrate over TF function points
void numIntegration()
{
	preIntegration[0] = interpPoints[0];

	for (int i = 1; i < 256; i++)
	{
		preIntegration[i] = preIntegration[i - 1] + interpPoints[i];
	}
}

void storeIntoTable()
{
	vec4 tmp;
	for (int x = 0; x < 256; x++)
	{
		for (int y = 0; y < 256; y++)
		{
			if (x > y)
			{
				tmp = preIntegration[x] - preIntegration[y];
				tmp *= (1.0f / float(x - y));
				imageStore(preintTable, ivec2(x, y), tmp);
			}

			if (x < y)
			{
				tmp = preIntegration[y] - preIntegration[x];
				tmp *= (1.0f / float(y - x));
				imageStore(preintTable, ivec2(x, y), tmp);
			}
			else
			{
				imageStore(preintTable, ivec2(x, y), interpPoints[x]);
			}
		}
	}
}

void main()
{
// NOT USED ANYMORE
/*
	// https://github.com/raphaelmenges/Voraca/blob/master/src/Transferfunction.cpp

	// parabola interpolation
	for (int i = 1; i < 2; i++)
	{
		vec3 p0 = controlPoints[0].rgb;
		vec3 p1 = controlPoints[1].rgb;
		vec3 p2 = controlPoints[2].rgb;
		vec3 p3 = controlPoints[3].rgb;

		int index = 0;
		for (float t = 0.0f; t < 1.0f; t += 1.0f / 256.0f)
		{
			vec4 U = vec4(t * t * t, t * t, t, 1.0f);
			float h1 = (-.5f * U.x + 1.f * U.y - .5f * U.z);
			float h2 = (1.5f * U.x + -2.5f * U.y + 1.f);
			float h3 = (-1.5f * U.x + 2.f * U.y + .5f * U.z);
			float h4 = (.5f * U.x - .5f * U.y);

			vec3 p = h1 * p0 + h2 * p1 + h3 * p2 + h4 * p3;
			interpPoints[index] = vec4(p, 1.0);
			index++;
		}

	}


	numIntegration();
	storeIntoTable();
	*/
}
