#version 450 core

--Vertex

#extension GL_ARB_explicit_attrib_location : enable

layout(location = 0) in vec3 vertex;
out vec2 texCoord;
out vec3 FragPos;

// https://community.khronos.org/t/rendering-a-skybox-after-drawing-post-process-effects-to-a-screen-quad/74002
out vec3 vsViewDirection;

uniform mat4 viewProjMatrix;
uniform mat4 viewMatrix;
uniform mat4 projMatrix;
uniform vec3 firstPlanePos;
uniform vec3 origin; // in view space


void main()
{
	texCoord = vec2((vertex.x + 1) / 2, (vertex.y + 1) / 2);
	//gl_Position = projMatrix * vec4(origin + vertex, 1);
	gl_Position = vec4(vertex, 1);

	vsViewDirection = mat3(inverse(viewMatrix)) * (inverse(projMatrix) * vec4(origin + vertex, 1)).xyz;
}



--Fragment
uniform sampler2DArray colorTexture;
uniform sampler2DArray viewDirTex;
uniform sampler2DArray mediumTexture;
uniform sampler2D skybox_texture;
uniform samplerCube skybox;
uniform mat4 viewProjMatrix;
uniform mat4 viewMatrix;
uniform mat4 projMatrix;

in vec2 texCoord;
in vec3 FragPos;
in vec3 vsViewDirection;

vec2 textureToViewSpace(vec2 pos);
vec2 viewToTextureSpace(vec2 pos);

out vec4 fragColor;

vec2 textureToViewSpace(vec2 pos){
	//return (pos - 0.5) * 2.0;
	return (pos - 0.5) * 2.0;
}

vec2 viewToTextureSpace(vec2 pos){
	//return (pos * 0.5) + 0.5;
	return (pos * 0.5) + 0.5;
}

void main()
{

	vec4 colorTex = texture(colorTexture, vec3(texCoord.xy, 0)).rgba;
	vec4 mediumTex = texture(mediumTexture, vec3(texCoord.xy, 0)).rgba;

	vec3 viewDir = mat3(inverse(viewMatrix)) * (inverse(projMatrix) * texture(viewDirTex, vec3(texCoord.xy,0)).xyzw).xyz;
	vec3 skybox_color = texture(skybox, normalize(viewDir + vsViewDirection)).rgb;

	// oddy willis blending
	float beta1 = colorTex.a;
	vec3 particle_over = beta1 * colorTex.rgb + mediumTex.rgb * (1.0 - beta1) * skybox_color.rgb * mediumTex.rgb;

	fragColor = vec4(particle_over, 1.0);
	//fragColor = vec4(colorTex.rgb, 1.0);
}