#pragma once

#include <glew.h>
#include <math.h>
#include <glm.hpp>
#include <qopenglframebufferobject.h>
#include <QOpenGLTexture>
#include <qopenglshaderprogram.h>

class VolumeRenderer
{
public:
	void setBufferUniforms(QOpenGLShaderProgram* m_refractiveVolumeProgram);
	void setSetupBufferUniforms(QOpenGLShaderProgram* m_setupProgram, GLint layer);
	void InitBuffers();
	void setFramebufferSize(int width, int height);
	void setSkyboxFramebufferSize(int width, int height);

	void VolumeRenderer::initCubemap();
	unsigned int loadCubemap(std::vector<std::string> faces);
	unsigned int loadTexture(char const* path);

	static void executeComputeShader(int numgroups_x, int numgroups_y, int numgroups_z)
	{
		glDispatchCompute(numgroups_x, numgroups_y, numgroups_z);
	}

	
	unsigned int m_fbo;
	unsigned int m_fbo_preint;
	unsigned int m_fbo_skybox;

	QOpenGLFramebufferObject* m_frameBuffer;
	unsigned int m_lightColorTexture;
	unsigned int m_lightDirectionTexture;
	unsigned int m_mediumColorTexture;
	unsigned int m_colorTexture;
	unsigned int m_viewDirectionTexture;
	unsigned int m_viewPositionTexture;
	unsigned int m_skyboxTexture;
	
	unsigned int m_debugTexture;

	unsigned int m_preintTableMedium;
	unsigned int m_preintTableColor;

	unsigned int m_envTexture;
	unsigned int cubeVAO, cubeVBO, skyboxVAO, skyboxVBO;
	unsigned int cubeTexture, cubemapTexture;
	

private:
	bool createBuffer(unsigned int textureLayer1, unsigned int textureLayer2, int width, int height);

	int m_width;
	int m_height;

	int m_skybox_width;
	int m_skybox_height;


};

