#include "VolumeRenderer.h"
#include <iostream>
#include <stb_image.h>

float cubeVertices[] = {
	// positions          // texture Coords
	-0.5f, -0.5f, -0.5f,  0.0f, 0.0f,
	 0.5f, -0.5f, -0.5f,  1.0f, 0.0f,
	 0.5f,  0.5f, -0.5f,  1.0f, 1.0f,
	 0.5f,  0.5f, -0.5f,  1.0f, 1.0f,
	-0.5f,  0.5f, -0.5f,  0.0f, 1.0f,
	-0.5f, -0.5f, -0.5f,  0.0f, 0.0f,

	-0.5f, -0.5f,  0.5f,  0.0f, 0.0f,
	 0.5f, -0.5f,  0.5f,  1.0f, 0.0f,
	 0.5f,  0.5f,  0.5f,  1.0f, 1.0f,
	 0.5f,  0.5f,  0.5f,  1.0f, 1.0f,
	-0.5f,  0.5f,  0.5f,  0.0f, 1.0f,
	-0.5f, -0.5f,  0.5f,  0.0f, 0.0f,

	-0.5f,  0.5f,  0.5f,  1.0f, 0.0f,
	-0.5f,  0.5f, -0.5f,  1.0f, 1.0f,
	-0.5f, -0.5f, -0.5f,  0.0f, 1.0f,
	-0.5f, -0.5f, -0.5f,  0.0f, 1.0f,
	-0.5f, -0.5f,  0.5f,  0.0f, 0.0f,
	-0.5f,  0.5f,  0.5f,  1.0f, 0.0f,

	 0.5f,  0.5f,  0.5f,  1.0f, 0.0f,
	 0.5f,  0.5f, -0.5f,  1.0f, 1.0f,
	 0.5f, -0.5f, -0.5f,  0.0f, 1.0f,
	 0.5f, -0.5f, -0.5f,  0.0f, 1.0f,
	 0.5f, -0.5f,  0.5f,  0.0f, 0.0f,
	 0.5f,  0.5f,  0.5f,  1.0f, 0.0f,

	-0.5f, -0.5f, -0.5f,  0.0f, 1.0f,
	 0.5f, -0.5f, -0.5f,  1.0f, 1.0f,
	 0.5f, -0.5f,  0.5f,  1.0f, 0.0f,
	 0.5f, -0.5f,  0.5f,  1.0f, 0.0f,
	-0.5f, -0.5f,  0.5f,  0.0f, 0.0f,
	-0.5f, -0.5f, -0.5f,  0.0f, 1.0f,

	-0.5f,  0.5f, -0.5f,  0.0f, 1.0f,
	 0.5f,  0.5f, -0.5f,  1.0f, 1.0f,
	 0.5f,  0.5f,  0.5f,  1.0f, 0.0f,
	 0.5f,  0.5f,  0.5f,  1.0f, 0.0f,
	-0.5f,  0.5f,  0.5f,  0.0f, 0.0f,
	-0.5f,  0.5f, -0.5f,  0.0f, 1.0f
};
float skyboxVertices[] = {
	// positions          
	-1.0f,  1.0f, -1.0f,
	-1.0f, -1.0f, -1.0f,
	 1.0f, -1.0f, -1.0f,
	 1.0f, -1.0f, -1.0f,
	 1.0f,  1.0f, -1.0f,
	-1.0f,  1.0f, -1.0f,

	-1.0f, -1.0f,  1.0f,
	-1.0f, -1.0f, -1.0f,
	-1.0f,  1.0f, -1.0f,
	-1.0f,  1.0f, -1.0f,
	-1.0f,  1.0f,  1.0f,
	-1.0f, -1.0f,  1.0f,

	 1.0f, -1.0f, -1.0f,
	 1.0f, -1.0f,  1.0f,
	 1.0f,  1.0f,  1.0f,
	 1.0f,  1.0f,  1.0f,
	 1.0f,  1.0f, -1.0f,
	 1.0f, -1.0f, -1.0f,

	-1.0f, -1.0f,  1.0f,
	-1.0f,  1.0f,  1.0f,
	 1.0f,  1.0f,  1.0f,
	 1.0f,  1.0f,  1.0f,
	 1.0f, -1.0f,  1.0f,
	-1.0f, -1.0f,  1.0f,

	-1.0f,  1.0f, -1.0f,
	 1.0f,  1.0f, -1.0f,
	 1.0f,  1.0f,  1.0f,
	 1.0f,  1.0f,  1.0f,
	-1.0f,  1.0f,  1.0f,
	-1.0f,  1.0f, -1.0f,

	-1.0f, -1.0f, -1.0f,
	-1.0f, -1.0f,  1.0f,
	 1.0f, -1.0f, -1.0f,
	 1.0f, -1.0f, -1.0f,
	-1.0f, -1.0f,  1.0f,
	 1.0f, -1.0f,  1.0f
};


void VolumeRenderer::setFramebufferSize(int width, int height)
{
	m_width = width;
	m_height = height;
}

void VolumeRenderer::setSkyboxFramebufferSize(int width, int height)
{
	m_skybox_width = width;
	m_skybox_height = height;
}

void VolumeRenderer::setBufferUniforms(QOpenGLShaderProgram* m_refractiveVolumeProgram)
{
	

	// use texture attachment 0 as read and attachment 1 as write
	glActiveTexture(GL_TEXTURE1);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_colorTexture);
	m_refractiveVolumeProgram->setUniformValue("color_buffer", 1);

	glActiveTexture(GL_TEXTURE2);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_lightColorTexture);
	m_refractiveVolumeProgram->setUniformValue("light_color_buffer", 2);

	glActiveTexture(GL_TEXTURE3);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_lightDirectionTexture);
	m_refractiveVolumeProgram->setUniformValue("light_dir_buffer", 3);

	glActiveTexture(GL_TEXTURE4);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_mediumColorTexture);
	m_refractiveVolumeProgram->setUniformValue("medium_color_buffer", 4);

	glActiveTexture(GL_TEXTURE5);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_viewDirectionTexture);
	m_refractiveVolumeProgram->setUniformValue("viewray_dir_buffer", 5);

	glActiveTexture(GL_TEXTURE6);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_viewPositionTexture);
	m_refractiveVolumeProgram->setUniformValue("viewray_pos_buffer", 6);

	glActiveTexture(GL_TEXTURE7);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_debugTexture);
	m_refractiveVolumeProgram->setUniformValue("debug_buffer", 7);

	glActiveTexture(GL_TEXTURE8);
	glBindTexture(GL_TEXTURE_2D, m_preintTableMedium);
	m_refractiveVolumeProgram->setUniformValue("preintTableMedium", 8);

	glActiveTexture(GL_TEXTURE9);
	glBindTexture(GL_TEXTURE_2D, m_preintTableColor);
	m_refractiveVolumeProgram->setUniformValue("preintTableColor", 9);

	

}

void VolumeRenderer::setSetupBufferUniforms(QOpenGLShaderProgram* m_setupProgram, GLint layer)
{


	// use texture attachment 0 as read and attachment 1 as write
	glActiveTexture(GL_TEXTURE1);
	glBindImageTexture(1, m_colorTexture, 0, GL_TRUE, layer, GL_WRITE_ONLY, GL_RGBA32F);
	m_setupProgram->setUniformValue("color_buffer", 1);

	glActiveTexture(GL_TEXTURE2);
	glBindImageTexture(2, m_lightColorTexture, 0, GL_TRUE, layer, GL_WRITE_ONLY, GL_RGBA32F);
	m_setupProgram->setUniformValue("light_color_buffer", 2);

	glActiveTexture(GL_TEXTURE3);
	glBindImageTexture(3, m_lightDirectionTexture, 0, GL_TRUE, layer, GL_WRITE_ONLY, GL_RGBA32F);
	m_setupProgram->setUniformValue("light_dir_buffer", 3);

	glActiveTexture(GL_TEXTURE4);
	glBindImageTexture(4, m_mediumColorTexture, 0, GL_TRUE, layer, GL_WRITE_ONLY, GL_RGBA32F);
	m_setupProgram->setUniformValue("medium_color_buffer", 4);

	glActiveTexture(GL_TEXTURE5);
	glBindImageTexture(5, m_viewDirectionTexture, 0, GL_TRUE, layer, GL_WRITE_ONLY, GL_RGBA32F);
	m_setupProgram->setUniformValue("viewray_dir_buffer", 5);

	glActiveTexture(GL_TEXTURE6);
	glBindImageTexture(6, m_viewPositionTexture, 0, GL_TRUE, layer, GL_WRITE_ONLY, GL_RGBA32F);
	m_setupProgram->setUniformValue("viewray_pos_buffer", 6);

	glActiveTexture(GL_TEXTURE7);
	glBindImageTexture(7, m_debugTexture, 0, GL_TRUE, layer, GL_WRITE_ONLY, GL_RGBA32F);
	m_setupProgram->setUniformValue("debug_buffer", 7);

	/*
	glActiveTexture(GL_TEXTURE7);
	glBindTexture(GL_TEXTURE_2D, m_preintTableMedium); // medium layer
	m_refractiveVolumeProgram->setUniformValue("preintTableMedium", 7);

	glActiveTexture(GL_TEXTURE8);
	glBindTexture(GL_TEXTURE_2D, m_preintTableColor); // medium layer
	m_refractiveVolumeProgram->setUniformValue("preintTableColor", 8);*/
}

void VolumeRenderer::InitBuffers()
{

	/* create 6 framebuffers with 2 layers each */
	//m_frameBuffer = new QOpenGLFramebufferObject(m_width, m_height, GL_TEXTURE_2D_ARRAY);
	
	glGenFramebuffers(1, &m_fbo);
	glBindFramebuffer(GL_FRAMEBUFFER, m_fbo);
	glObjectLabel(GL_FRAMEBUFFER, m_fbo, -1, "Framebuffer_6layers");

	glGenTextures(1, &m_colorTexture);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_colorTexture);
	glTexStorage3D(GL_TEXTURE_2D_ARRAY, 1, GL_RGBA32F, m_width, m_height, 2);
	glObjectLabel(GL_TEXTURE, m_colorTexture, -1, "Texture_color");
	glFramebufferTexture(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, m_colorTexture, 0);

	glGenTextures(1, &m_lightColorTexture);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_lightColorTexture);
	glTexStorage3D(GL_TEXTURE_2D_ARRAY, 1, GL_RGBA32F, m_width, m_height, 2);
	glObjectLabel(GL_TEXTURE, m_lightColorTexture, -1, "Texture_lightColor");
	glFramebufferTexture(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT1, m_lightColorTexture, 0);

	glGenTextures(1, &m_lightDirectionTexture);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_lightDirectionTexture);
	glTexStorage3D(GL_TEXTURE_2D_ARRAY, 1, GL_RGBA32F, m_width, m_height, 2);
	glObjectLabel(GL_TEXTURE, m_lightDirectionTexture, -1, "Texture_lightDirection");
	glFramebufferTexture(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT2, m_lightDirectionTexture, 0);

	glGenTextures(1, &m_mediumColorTexture);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_mediumColorTexture);
	glTexStorage3D(GL_TEXTURE_2D_ARRAY, 1, GL_RGBA32F, m_width, m_height, 2);
	glObjectLabel(GL_TEXTURE, m_mediumColorTexture, -1, "Texture_mediumColor");
	glFramebufferTexture(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT3, m_mediumColorTexture, 0);

	glGenTextures(1, &m_viewDirectionTexture);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_viewDirectionTexture);
	glTexStorage3D(GL_TEXTURE_2D_ARRAY, 1, GL_RGBA32F, m_width, m_height, 2);
	glObjectLabel(GL_TEXTURE, m_viewDirectionTexture, -1, "Texture_viewDirection");
	glFramebufferTexture(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT4, m_viewDirectionTexture, 0);

	glGenTextures(1, &m_viewPositionTexture);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_viewPositionTexture);
	glTexStorage3D(GL_TEXTURE_2D_ARRAY, 1, GL_RGBA32F, m_width, m_height, 2);
	glObjectLabel(GL_TEXTURE, m_viewPositionTexture, -1, "Texture_viewPosition");
	glFramebufferTexture(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT5, m_viewPositionTexture, 0);

	glGenTextures(1, &m_debugTexture);
	glBindTexture(GL_TEXTURE_2D_ARRAY, m_debugTexture);
	glTexStorage3D(GL_TEXTURE_2D_ARRAY, 1, GL_RGBA32F, m_width, m_height, 2);
	glObjectLabel(GL_TEXTURE, m_debugTexture, -1, "Texture_debug");
	glFramebufferTexture(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT6, m_debugTexture, 0);

	if (glCheckFramebufferStatus(GL_FRAMEBUFFER) != GL_FRAMEBUFFER_COMPLETE) {
		auto status = glCheckFramebufferStatus(GL_FRAMEBUFFER);
		std::cout << status << std::endl;
		std::cout << "ERROR::FRAMEBUFFER:: Framebuffer is not complete!" << std::endl;
	}
	glBindFramebuffer(GL_FRAMEBUFFER, 0);

	/* FBO for skybox texture */
	glGenFramebuffers(1, &m_fbo_skybox);
	glBindFramebuffer(GL_FRAMEBUFFER, m_fbo_skybox);
	glObjectLabel(GL_FRAMEBUFFER, m_fbo_skybox, -1, "Framebuffer_skybox");

	glGenTextures(1, &m_skyboxTexture);
	glBindTexture(GL_TEXTURE_2D, m_skyboxTexture);
	glTexStorage2D(GL_TEXTURE_2D, 1, GL_RGBA32F, m_skybox_width, m_skybox_height);
	glObjectLabel(GL_TEXTURE, m_skyboxTexture, -1, "Texture_skybox");
	glFramebufferTexture(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, m_skyboxTexture, 0);
	

	/* PREINT TABLES */
	glGenTextures(1, &m_preintTableMedium);
	glBindTexture(GL_TEXTURE_2D, m_preintTableMedium);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	float border[] = { 0.0f, 0.0f, 0.0f, 0.0f };
	//glTexParameterfv(GL_TEXTURE_2D, GL_TEXTURE_BORDER_COLOR, border);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexStorage2D(GL_TEXTURE, 1, GL_RGBA8, 256, 256);
	glObjectLabel(GL_TEXTURE, m_preintTableMedium, -1, "Texture_preintegrationMedium");
	//glFramebufferTexture(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT6, m_preintTableMedium, 0);

	glGenTextures(1, &m_preintTableColor);
	glBindTexture(GL_TEXTURE_2D, m_preintTableColor);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameterfv(GL_TEXTURE_2D, GL_TEXTURE_BORDER_COLOR, border);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_BORDER);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_BORDER);
	glTexStorage2D(GL_TEXTURE, 1, GL_RGBA8, 256, 256);
	glObjectLabel(GL_TEXTURE, m_preintTableColor, -1, "Texture_preintegrationColor");
	
	//glFramebufferTexture(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT7, m_preintTableColor, 0);
	
	//glGenTextures(1, &m_preintTableColor);
	
	//glGenTextures(1, &m_preintTableMedium);
	

	glBindTexture(GL_TEXTURE_2D, 0);

	initCubemap();
	
	/*
	glGenTextures(1, &m_preintTableMedium);
	glBindTexture(GL_TEXTURE_2D, m_preintTableMedium);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	float border[] = { 0.0f, 0.0f, 0.0f, 0.0f };
	glTexParameterfv(GL_TEXTURE_2D, GL_TEXTURE_BORDER_COLOR, border);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_BORDER);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_BORDER);
	glTexStorage2D(GL_TEXTURE_2D, 1, GL_RGBA8, 256, 256);

	glGenTextures(1, &m_preintTableColor);
	glBindTexture(GL_TEXTURE_2D, m_preintTableMedium);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameterfv(GL_TEXTURE_2D, GL_TEXTURE_BORDER_COLOR, border);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_BORDER);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_BORDER);
	glTexStorage2D(GL_TEXTURE_2D, 1, GL_RGBA8, 256, 256);

	glBindTexture(GL_TEXTURE_2D, 0);
	*/
	
}

void VolumeRenderer::initCubemap() {

	glGenVertexArrays(1, &cubeVAO);
	glGenBuffers(1, &cubeVBO);
	glBindVertexArray(cubeVAO);
	glBindBuffer(GL_ARRAY_BUFFER, cubeVBO);
	glBufferData(GL_ARRAY_BUFFER, sizeof(cubeVertices), &cubeVertices, GL_STATIC_DRAW);
	glEnableVertexAttribArray(0);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 5 * sizeof(float), (void*)0);
	glEnableVertexAttribArray(1);
	glVertexAttribPointer(1, 2, GL_FLOAT, GL_FALSE, 5 * sizeof(float), (void*)(3 * sizeof(float)));

	glGenVertexArrays(1, &skyboxVAO);
	glGenBuffers(1, &skyboxVBO);
	glBindVertexArray(skyboxVAO);
	glBindBuffer(GL_ARRAY_BUFFER, skyboxVBO);
	glBufferData(GL_ARRAY_BUFFER, sizeof(skyboxVertices), &skyboxVertices, GL_STATIC_DRAW);
	glEnableVertexAttribArray(0);
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, 3 * sizeof(float), (void*)0);


	std::vector<std::string> faces
	{
		("res/textures/right.jpg"),
		("res/textures/left.jpg"),
		("res/textures/top.jpg"),
		("res/textures/bottom.jpg"),
		("res/textures/front.jpg"),
		("res/textures/back.jpg")
	};
	cubemapTexture = loadCubemap(faces);
}

// https://learnopengl.com/code_viewer_gh.php?code=src/4.advanced_opengl/6.1.cubemaps_skybox/cubemaps_skybox.cpp
unsigned int VolumeRenderer::loadCubemap(std::vector<std::string> faces) {

	// ENV map
	glGenTextures(1, &m_envTexture);
	glBindTexture(GL_TEXTURE_CUBE_MAP, m_envTexture);

	int width, height, nrChannels;
	for (unsigned int i = 0; i < faces.size(); i++) {
		unsigned char* data = stbi_load(faces[i].c_str(), &width, &height, &nrChannels, 0);
		if (data)
		{
			glTexImage2D(GL_TEXTURE_CUBE_MAP_POSITIVE_X + i, 0, GL_RGB, width, height, 0, GL_RGB, GL_UNSIGNED_BYTE, data);
			stbi_image_free(data);
		}
		else
		{
			std::cout << "Cubemap texture failed to load at path: " << faces[i] << std::endl;
			stbi_image_free(data);
		}
	}

	glTexParameteri(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_CUBE_MAP, GL_TEXTURE_WRAP_R, GL_CLAMP_TO_EDGE);

	return m_envTexture;
}



