#pragma once
#include <qwidget.h>
#include <QPainter>
#include <qslider.h>
#include "qpoint.h"
#include <QMouseEvent>
#include <QComboBox>
#include "qboxlayout.h"

class MainWindow;
class TransferFunctionWidget : public QWidget
{
private:

	MainWindow* m_mainWindow;
	QComboBox* m_colorPicker;
	QComboBox* m_pointPicker;

	QPoint m_redPoints[5];
	QPoint m_greenPoints[5];
	QPoint m_bluePoints[5];
	QPoint m_alphaPoints[5];

	void updatePoints(QPoint* points, QPoint mousePos);

	void mapPoints();

	QVector2D normalizePoint(QPoint point);

	


	int xStartValue = 20;
	int yStartValue = 140;

	int xMaxValue = 190;
	int yMaxValue = 20;

	void setupPoints(bool is_medium);

	QSlider horizontal;

public:
	//TransferFunctionWidget(QWidget* parent, MainWindow* mainWindow);
	TransferFunctionWidget(QWidget* parent, MainWindow* mainWindow, QComboBox* colorPicker, QComboBox* pointPicker, bool is_medium);
	~TransferFunctionWidget();
	void paintEvent(QPaintEvent* e);
	void mouseMoveEvent(QMouseEvent* event);
	int m_selectedPoint = 0;
	int m_selectedColor = 0;

	QVector2D m_redValues[5];
	QVector2D m_greenValues[5];
	QVector2D m_blueValues[5];
	QVector2D m_alphaValues[5];
	unsigned int m_texture_handle;
signals:

public slots:

	void pointSelectionChanged(int value);
	void colorSelectionChanged(int value);
};

