#pragma once

#include <glm.hpp>
#include <vector>
#include <QOpenGLWidget>
#include <QOpenGLFunctions>
#include <QOpenGLShaderProgram>
#include <QOpenGLVertexArrayObject>
#include <QOpenGLBuffer>
#include <QGLShader>
#include <QOpenGLShaderProgram>
#include <QFileSystemWatcher>
#include <QOpenGLDebugLogger>
#include <QOpenGLTexture>

const int BEZIER_STEPS = 256;
const int MIN_BEZIER_STEPS = 64;

//http://graphicsrunner.blogspot.com/2009/01/volume-rendering-102-transfer-functions.html
class TransferFunction
{
	enum tfType {
		COLOR,
		ALPHA,
		MEDIUM
	};

	class ControlPoint
	{

	public:

		/* constructor for color control points */
		ControlPoint(glm::vec3 pos, glm::vec4 col);
		/* constructor for opacity control points */
		ControlPoint(float alpha, float density);

		glm::vec4 m_color;
		glm::vec4 m_coord;
		float m_value;

		glm::vec2 getXY()
		{
			return glm::vec2(m_coord.x, m_coord.y);
		}

		glm::vec3 getVec3()
		{
			return glm::vec3(m_coord.x, m_coord.y, m_coord.z);
		}

		QVector4D getQVec4() 
		{ 
			
			QVector4D result = QVector4D(m_coord.x, m_coord.y, m_coord.z, m_coord.w);
			return result; 
		}
	};

public:

	TransferFunction(std::vector<glm::vec4> controlPoints, std::vector<glm::vec4> colors);
	TransferFunction(std::vector<glm::vec2> controlPoints);

	std::vector<ControlPoint*> m_controlPointsList;
	std::vector<glm::vec4> m_controlPointsColor;

	void updateColorForPoint(int pointId, glm::vec3(color));

	void computePreintegrationTable(GLuint texture_handle);
	void computeBezierInterp(std::vector<glm::vec4> &interpPoints);
	void setColorForControlPoints(std::vector<glm::vec4> cpPoints);
};



