/*
* Copyright (C) 2017
* Computer Graphics Group, The Institute of Computer Graphics and Algorithms, TU Wien
* Written by Tobias Klein <tklein@cg.tuwien.ac.at>
* All rights reserved.
*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "ui_MainWindow.h"
#include "Volume.h"
#include "GLWidget.h"

#include <QMainWindow>
#include <QPushButton>
#include <QLabel>
#include <QProgressBar>
#include <QStatusBar>
#include <QVariant>
#include "TransferFunctionWidget.h"

class MainWindow : public QMainWindow
{
	Q_OBJECT

public:

	MainWindow(QWidget *parent = 0);
	~MainWindow();


	void updateGL(TransferFunctionWidget* transferFunction);
	TransferFunctionWidget* m_colorTransferFunctionWidget;
	TransferFunctionWidget* m_mediumTransferFuncWidget;

protected slots :

	void openFileAction();
	void closeAction();
	void renderingModeChanged(int value);
	void refractionChanged(int value);
	void filteringChanged(int value);
	void intensityChanged(int value);
	void scatteringChanged(int value);
	void x_dir_Changed(int value);
	void y_dir_Changed(int value);
	void r_color_changed(int value);
	void g_color_changed(int value);
	void b_color_changed(int value);


private:

	// USER INTERFACE ELEMENTS

	Ui_MainWindow *m_Ui;

	// DATA 
	enum DataType
	{
		VOLUME = 0,
		VECTORFIELD	 = 1,
		MULTIVARIATE = 2
	};

	struct FileType
	{
		QString			filename;
		DataType		type;
	} m_FileType;

	Volume *m_Volume;

	GLWidget *m_glWidget;
	
	

};

#endif
