#include "MainWindow.h"

#include <QFileDialog>

#include <QPainter>


MainWindow::MainWindow(QWidget *parent)
	: QMainWindow(parent), m_Volume(0)
{
	m_Ui = new Ui_MainWindow();
	m_Ui->setupUi(this);

	QLayout *layout = m_Ui->controls->layout();
	layout->setAlignment(Qt::AlignTop);
	m_Ui->controls->setLayout(layout);

	m_glWidget = new GLWidget(this, this);
	m_Ui->glLayout->addWidget(m_glWidget);

	m_colorTransferFunctionWidget = new TransferFunctionWidget(m_Ui->groupBox_color, this,m_Ui->comboBox_color_2,m_Ui->comboBox_point_2, false);

	m_mediumTransferFuncWidget = new TransferFunctionWidget(m_Ui->groupBox_medium, this, m_Ui->comboBox_color, m_Ui->comboBox_point, true);
	m_Ui->groupBox_medium->layout()->addWidget(m_mediumTransferFuncWidget);
	m_Ui->groupBox_color->layout()->addWidget(m_colorTransferFunctionWidget);

	// signals and slots are used for communication between objects
	// the signals and slots mechanism is a central feature of Qt
	// see here: http://doc.qt.io/qt-4.8/signalsandslots.html
	connect(m_Ui->actionOpen, SIGNAL(triggered()), this, SLOT(openFileAction()));
	connect(m_Ui->actionClose, SIGNAL(triggered()), this, SLOT(closeAction()));
	connect(m_Ui->switch_renderingMode, SIGNAL(currentIndexChanged(int)), this, SLOT(renderingModeChanged(int)));
	connect(m_Ui->checkBox_scattering, SIGNAL(stateChanged(int)), this, SLOT(scatteringChanged(int)));
	connect(m_Ui->checkBox_filtering, SIGNAL(stateChanged(int)), this, SLOT(filteringChanged(int)));
	connect(m_Ui->checkBox_intensity, SIGNAL(stateChanged(int)), this, SLOT(intensityChanged(int)));
	connect(m_Ui->checkBox_refraction, SIGNAL(stateChanged(int)), this, SLOT(refractionChanged(int)));
	connect(m_Ui->horizontalSlider_light_x, SIGNAL(valueChanged(int)), this, SLOT(x_dir_Changed(int)));
	connect(m_Ui->horizontalSlider_light_y, SIGNAL(valueChanged(int)), this, SLOT(y_dir_Changed(int)));
	connect(m_Ui->horizontalSlider_color_r, SIGNAL(valueChanged(int)), this, SLOT(r_color_changed(int)));
	connect(m_Ui->horizontalSlider_color_g, SIGNAL(valueChanged(int)), this, SLOT(g_color_changed(int)));
	connect(m_Ui->horizontalSlider_color_b, SIGNAL(valueChanged(int)), this, SLOT(b_color_changed(int)));

	m_Ui->switch_renderingMode->setCurrentIndex(4);
	m_Ui->horizontalSlider_light_x->valueChanged(m_Ui->horizontalSlider_light_x->value());
	m_Ui->horizontalSlider_light_y->valueChanged(m_Ui->horizontalSlider_light_y->value());


	m_Ui->checkBox_scattering->stateChanged(0);
	m_Ui->checkBox_filtering->stateChanged(0);
	m_Ui->checkBox_intensity->stateChanged(0);
	m_Ui->checkBox_refraction->stateChanged(0);
}

MainWindow::~MainWindow()
{
}


//-------------------------------------------------------------------------------------------------
// Slots
//-------------------------------------------------------------------------------------------------

void MainWindow::openFileAction()
{
	QString filename = QFileDialog::getOpenFileName(this, "Data File", 0, tr("Data Files (*.dat *.gri *.csv)"));

	if (!filename.isEmpty())
	{
		// store filename
		m_FileType.filename = filename;
		std::string fn = filename.toStdString();
		bool success = false;

		// progress bar and top label
		m_Ui->progressBar->setEnabled(true);
		m_Ui->labelTop->setText("Loading data ...");

		// load data according to file extension
		if (fn.substr(fn.find_last_of(".") + 1) == "dat")		// LOAD VOLUME
		{
			// create VOLUME
			m_FileType.type = VOLUME;
			m_Volume = new Volume();

			// load file
			success = m_Volume->loadFromFile(filename, m_Ui->progressBar);
		}

		m_Ui->progressBar->setEnabled(false);

		// status message
		if (success)
		{
			QString type;
			if (m_FileType.type == VOLUME) type = "VOLUME";
			else if (m_FileType.type == VECTORFIELD) type = "VECTORFIELD";
			else if (m_FileType.type == MULTIVARIATE) type = "MULTIVARIATE";
			m_Ui->labelTop->setText("File LOADED [" + filename + "] - Type [" + type + "]");
			m_glWidget->volumeTextureLoaded(m_Volume);
		}
		else
		{
			m_Ui->labelTop->setText("ERROR loading file " + filename + "!");
			m_Ui->progressBar->setValue(0);
		}
	}
}

void MainWindow::closeAction()
{
	close();
}



void MainWindow::renderingModeChanged(int value)
{
	m_glWidget->m_renderingMode = value;
	m_glWidget->update();
}

void MainWindow::refractionChanged(int value)
{
	bool bool_value = true ? (value == 2) : false;
	m_glWidget->m_refractionEnabled = bool_value;
	m_glWidget->update();
}

void MainWindow::filteringChanged(int value)
{
	bool bool_value = true ? (value == 2) : false;
	m_glWidget->m_filteringEnabled = bool_value;
	m_glWidget->update();
}

void MainWindow::intensityChanged(int value)
{
	bool bool_value = true ? (value == 2) : false;
	m_glWidget->m_correctionEnabled = bool_value;
	m_glWidget->update();
}

void MainWindow::scatteringChanged(int value)
{	
	bool bool_value = true ? (value == 2) : false;
	m_glWidget->m_scatteringEnabled = bool_value;
	m_glWidget->update();
}

void MainWindow::x_dir_Changed(int value)
{
	m_glWidget->m_lightdir_x = value;
	m_glWidget->update();
}

void MainWindow::y_dir_Changed(int value)
{
	m_glWidget->m_lightdir_y = value;
	m_glWidget->update();
}

void MainWindow::r_color_changed(int value)
{
	m_glWidget->m_lightcolor_r = value / 255.0f;
	m_glWidget->update();
}

void MainWindow::g_color_changed(int value)
{
	m_glWidget->m_lightcolor_g = value / 255.0f;
	m_glWidget->update();
}

void MainWindow::b_color_changed(int value)
{
	m_glWidget->m_lightcolor_b = value / 255.0f;
	m_glWidget->update();
}

//TODO recalculate preintegration
void MainWindow::updateGL(TransferFunctionWidget* transferFunction) {
	m_glWidget->recalculatePreintegrationTable(transferFunction);
	m_glWidget->update();
}

