/*
* Copyright (C) 2017
* Computer Graphics Group, The Institute of Computer Graphics and Algorithms, TU Wien
* Written by Tobias Klein <tklein@cg.tuwien.ac.at>
* All rights reserved.
*/

#pragma once

#include "VolumeRenderer.h"
#include <QOpenGLWidget>
#include <QOpenGLFunctions>
#include <QOpenGLShaderProgram>
#include <QOpenGLVertexArrayObject>
#include <QOpenGLBuffer>
#include <QGLShader>
#include <QOpenGLShaderProgram>
#include <QFileSystemWatcher>
#include <QOpenGLDebugLogger>
#include <QOpenGLTexture>

#include "Camera.h"
#include "Volume.h"
#include "LightSource.h"
#include "TransferFunction.h"
#include "TransferFunctionWidget.h"


class MainWindow;

class GLWidget : public QOpenGLWidget, protected QOpenGLFunctions
{
	Q_OBJECT

public:
	GLWidget(QWidget *parent, MainWindow *mainWindow);
	~GLWidget();
	void recalculatePreintegrationTable(TransferFunctionWidget *transferfunction);
	Camera m_camera;
	LightSource *m_lightSource;
	VolumeRenderer* m_refrVolRenderer;
	int m_renderingMode;
	bool m_scatteringEnabled;
	bool m_filteringEnabled;
	bool m_refractionEnabled;
	bool m_correctionEnabled;
	
	float m_lightdir_x;
	float m_lightdir_y;
	float m_lightdir_z = -100.0;

	float m_lightcolor_r = 1.0f;
	float m_lightcolor_g = 1.0f;
	float m_lightcolor_b = 1.0f;


public slots:
	void cleanup();
	void volumeTextureLoaded(Volume *volume);

signals:

protected:

	void mousePressEvent(QMouseEvent *event) Q_DECL_OVERRIDE;
	void mouseMoveEvent(QMouseEvent *event) Q_DECL_OVERRIDE;
	void keyPressEvent(QKeyEvent *event) Q_DECL_OVERRIDE;
	void keyReleaseEvent(QKeyEvent *event) Q_DECL_OVERRIDE;
	void wheelEvent(QWheelEvent *event) Q_DECL_OVERRIDE;
	glm::vec3 recalculateLight();

protected slots:

	void paintGL() Q_DECL_OVERRIDE;
	void initializeGL() Q_DECL_OVERRIDE;
	void resizeGL(int w, int h) Q_DECL_OVERRIDE;
	void fileChanged(const QString &path);
	void handleLoggedMessage();

private:

	void initglsw();
	void loadShaders();
	void loadSetupShader();
	void loadPreintShader();
	TransferFunction* m_transferFunction;
	void loadPostProcessingShaders();
	void loadRefractiveVolumeShaders();
	void initPostProcessing();
	
	void initRefractiveRendering();
	void refreshLightPlaneVertices();

	QOpenGLShaderProgram *m_programCube;
	QOpenGLShaderProgram *m_programVolume;

	/* OWN */
	QOpenGLShaderProgram *m_setupBuffersProgram;
	QOpenGLShaderProgram *m_refractiveVolumeProgram;
	QOpenGLShaderProgram *m_preintegrationProgram;

	QOpenGLShaderProgram* m_postProcessingShaderProgram;
	QOpenGLShaderProgram* m_skyboxProgram;

	QOpenGLVertexArrayObject m_vaoPostprocessingVerticesQuad;

	QOpenGLBuffer m_vertexBufferPost;
	QOpenGLBuffer m_indexBufferPost;
	
	QOpenGLShader *m_vertexShaderVolume;
	QOpenGLShader *m_fragmentShaderVolume;

	QOpenGLVertexArrayObject m_vaoCube;
	QOpenGLVertexArrayObject m_vaoQuad;

	/*OWN*/
	QOpenGLVertexArrayObject m_vaoLightPlaneVertices;
	QOpenGLBuffer m_vertexBufferLightPlanes;
	
	QOpenGLBuffer m_vertexBuffer;
	QOpenGLBuffer m_indexBuffer;
	QOpenGLBuffer m_texCoordBuffer;

	QOpenGLBuffer m_vertexBufferQuad;
	QOpenGLBuffer m_indexBufferQuad;

	QOpenGLTexture *m_VolumeTexture;

	QOpenGLDebugLogger *m_logger;
	
	QOpenGLFramebufferObject *m_FBO_frontFaces;
	QOpenGLFramebufferObject *m_FBO_backFaces;

	QFileSystemWatcher *m_fileWatcher;

	QPoint m_lastPos;

	MainWindow *m_MainWindow;
	static const int m_lightPlaneNumbers = 400;
};


