#version 330 core

// input vectors
in vec4 in_position;
in vec3 in_normal;
in vec2 in_texture;

// Values that stay constant for the whole mesh.
uniform mat4 model_view; // Model to World
uniform mat4 projection; // MVP
uniform vec3 in_camera; // cam position

//Normal matrix
uniform mat4 normal_mat; // Model to world inverse transpose (normal matrix)

// Output data ; will be interpolated for each fragment.
//out vec2 texCoord;
out vec3 pos;
out vec3 out_normal;
out vec3 eye;

//water constants
const float pi = 3.14159;
uniform float waterHeight;
uniform float time;
uniform int numWaves;
uniform vec4 amplitude;
uniform vec4 wavelength;
uniform vec4 speed;
uniform vec4 xDirection;
uniform vec4 zDirection;

float wave(int i, float x, float y) {
	float wl[4] = float[4](wavelength[0], wavelength[1], wavelength[2], wavelength[3]);
	float s[4] = float[4](speed[0], speed[1], speed[2], speed[3]);
	vec2 d[4] = vec2[4](vec2(xDirection[0], zDirection[0]), vec2(xDirection[1], zDirection[1]), vec2(xDirection[2], zDirection[2]), vec2(xDirection[3], zDirection[3]));
	float a[4] = float[4](amplitude[0], amplitude[1], amplitude[2], amplitude[3]);

    float frequency = 2*pi/wl[i];
    float phase = s[i] * frequency;
    float theta = dot(d[i], vec2(x, y));
    return a[i] * sin(theta * frequency + time * phase);
}

float waveHeight(float x, float y) {
    float height = 0.0;
    for (int i = 0; i < numWaves; ++i)
        height += wave(i, x, y);
    return height;
}

float dWavedx(int i, float x, float y) {
	float wl[4] = float[4](wavelength[0], wavelength[1], wavelength[2], wavelength[3]);
	float s[4] = float[4](speed[0], speed[1], speed[2], speed[3]);
	vec2 d[4] = vec2[4](vec2(xDirection[0], zDirection[0]), vec2(xDirection[1], zDirection[1]), vec2(xDirection[2], zDirection[2]), vec2(xDirection[3], zDirection[3]));
	float a[4] = float[4](amplitude[0], amplitude[1], amplitude[2], amplitude[3]);

    float frequency = 2*pi/wl[i];
    float phase = s[i] * frequency;
    float theta = dot(d[i], vec2(x, y));
    float A = a[i] * d[i].x * frequency;
    return A * cos(theta * frequency + time * phase);
}

float dWavedy(int i, float x, float y) {
	float wl[4] = float[4](wavelength[0], wavelength[1], wavelength[2], wavelength[3]);
	float s[4] = float[4](speed[0], speed[1], speed[2], speed[3]);
	vec2 d[4] = vec2[4](vec2(xDirection[0], zDirection[0]), vec2(xDirection[1], zDirection[1]), vec2(xDirection[2], zDirection[2]), vec2(xDirection[3], zDirection[3]));
	float a[4] = float[4](amplitude[0], amplitude[1], amplitude[2], amplitude[3]);

    float frequency = 2*pi/wl[i];
    float phase = s[i] * frequency;
    float theta = dot(d[i], vec2(x, y));
    float A = a[i] * d[i].y * frequency;
    return A * cos(theta * frequency + time * phase);
}

vec3 waveNormal(float x, float y) {
    float dx = 0.0;
    float dy = 0.0;
    for (int i = 0; i < numWaves; ++i) {
        dx += dWavedx(i, x, y);
        dy += dWavedy(i, x, y);
    }
    vec3 n = vec3(-dx, -dy, 1.0);
    return normalize(n);
}

float sinus(float x)
{
	float f = 2 * pi / 0.5f;
	float p = speed[0] * f;
	//return amplitude[0] * sin(2 * pi * f * (x/(f * 0.5f) - time) + p);
	return amplitude[0];
}

void main(){
/*
	// Output position of the vertex, in clip space : mvp * position
	//vec4 position = projection * in_position;
	
	vec4 position = projection * in_position;
	position.y += 200 * waveHeight(in_position.x, in_position.z);
	//position.x += sinus(position.z);

	gl_Position =  position;
	// calculate normals
	out_normal = normalize(vec3(normal_mat* vec4(in_normal, 1.0f)));
	
	vec4 tmp = model_view*in_position;
	vec3 positionW = tmp.xyz;
	// set texture coords
    //texCoord = in_texture;

	// get vertex pos in eye coordinates
	eye = normalize(positionW);
	//col = vec4(-waveHeight(in_position.x, in_position.y),-waveHeight(in_position.x, in_position.y), -waveHeight(in_position.x, in_position.y), 1.0f);
	//if (waveHeight(in_position.x, in_position.z) > 0)
	//{
		//col = vec4(1.0f,1.0f,1.0f,1.0f);
	//}
	if (waveHeight(in_position.y, in_position.z) <= 1)
	{
		col = vec4(1.0f,1.0f,1.0f,1.0f);
	} else {
		col = vec4(0.5f,1.0f,1.0f,1.0f);
	}
	*/

	vec4 position = projection * in_position;
	float water = waterHeight + waveHeight(position.x, position.z);
	position.y += water;
	pos = position.xyz / position.w;
	gl_Position = position;

	vec4 posw = in_position;
	posw.y += water;
	vec4 tmp = model_view*(vec4(in_camera,1) - posw);
	vec3 positionW = tmp.xyz;
	eye = normalize(positionW);

	out_normal = waveNormal(position.x, position.z);
}