#version 330 core

uniform sampler2D texUnit;
uniform sampler2DShadow shadowSampler;

// Interpolated values from the vertex shaders
in vec2 texCoord;
in vec4 shadowCoord;
in vec3 out_normal;

uniform vec3 L;
uniform vec3 I;
uniform vec3 V;

//ambient intensity * ka
uniform vec3 ambient;

uniform float kd;
uniform float ks;
uniform float shininess;

// Ouput data
out vec3 color;

void main()
{
	vec3 texColor = texture2D(texUnit, texCoord).rgb;

	float shadow = 0;
	shadow += textureProjOffset(shadowSampler, shadowCoord, ivec2(-1,1));
	shadow += textureProjOffset(shadowSampler, shadowCoord, ivec2(-1,1));
	shadow += textureProjOffset(shadowSampler, shadowCoord, ivec2(1,1));
	shadow += textureProjOffset(shadowSampler, shadowCoord, ivec2(1,-1));
	shadow = 0.25 * shadow;
	
	vec3 N = normalize(out_normal);
	vec3 R = normalize(-reflect(L,N));
	vec3 colInt = ambient * texColor + shadow * kd * I * max(dot(N, L), 0.0) * texColor + ks * shadow * I * max(dot(N, L), 0.0) * pow(max(dot(R, V), 0.0), shininess);
	color = colInt;
	
	//color = texColor;
}